/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.client;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.spdy.Controller;
import org.eclipse.jetty.spdy.ISession;
import org.eclipse.jetty.spdy.IdleListener;
import org.eclipse.jetty.spdy.api.GoAwayInfo;
import org.eclipse.jetty.spdy.parser.Parser;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class SPDYConnection
extends AbstractConnection
implements Controller,
IdleListener {
    private static final Logger LOG = Log.getLogger(SPDYConnection.class);
    private final ByteBufferPool bufferPool;
    private final Parser parser;
    private final int bufferSize;
    private volatile ISession session;
    private volatile boolean idle = false;

    public SPDYConnection(EndPoint endPoint, ByteBufferPool bufferPool, Parser parser, Executor executor) {
        this(endPoint, bufferPool, parser, executor, 8192);
    }

    public SPDYConnection(EndPoint endPoint, ByteBufferPool bufferPool, Parser parser, Executor executor, int bufferSize) {
        super(endPoint, executor, false);
        this.bufferPool = bufferPool;
        this.parser = parser;
        this.onIdle(true);
        this.bufferSize = bufferSize;
    }

    @Override
    public void onOpen() {
        super.onOpen();
        this.fillInterested();
    }

    @Override
    public void onFillable() {
        ByteBuffer buffer = this.bufferPool.acquire(this.bufferSize, true);
        boolean readMore = this.read(buffer) == 0;
        this.bufferPool.release(buffer);
        if (readMore) {
            this.fillInterested();
        }
    }

    protected int read(ByteBuffer buffer) {
        EndPoint endPoint = this.getEndPoint();
        while (true) {
            int filled = this.fill(endPoint, buffer);
            LOG.debug("Read {} bytes", filled);
            if (filled == 0) {
                return 0;
            }
            if (filled < 0) {
                this.shutdown(this.session);
                return -1;
            }
            this.parser.parse(buffer);
        }
    }

    private int fill(EndPoint endPoint, ByteBuffer buffer) {
        try {
            if (endPoint.isInputShutdown()) {
                return -1;
            }
            return endPoint.fill(buffer);
        }
        catch (IOException x) {
            endPoint.close();
            throw new RuntimeIOException(x);
        }
    }

    @Override
    public void write(ByteBuffer buffer, Callback callback) {
        EndPoint endPoint = this.getEndPoint();
        endPoint.write(callback, buffer);
    }

    @Override
    public void close() {
        this.goAway(this.session);
    }

    @Override
    public void close(boolean onlyOutput) {
        EndPoint endPoint = this.getEndPoint();
        LOG.debug("Shutting down output {}", endPoint);
        endPoint.shutdownOutput();
        if (!onlyOutput) {
            LOG.debug("Closing {}", endPoint);
            endPoint.close();
        }
    }

    @Override
    public void onIdle(boolean idle) {
        this.idle = idle;
    }

    @Override
    protected boolean onReadTimeout() {
        boolean idle = this.idle;
        LOG.debug("Idle timeout on {}, idle={}", this, idle);
        if (idle) {
            this.goAway(this.session);
        }
        return false;
    }

    protected void goAway(ISession session) {
        if (session != null) {
            session.goAway(new GoAwayInfo(), new Callback.Adapter());
        }
    }

    private void shutdown(ISession session) {
        if (session != null && !this.getEndPoint().isOutputShutdown()) {
            session.shutdown();
        }
    }

    protected ISession getSession() {
        return this.session;
    }

    public void setSession(ISession session) {
        this.session = session;
    }
}

