/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jetty.client.api.ContentProvider;

public class PathContentProvider
implements ContentProvider {
    private final Path filePath;
    private final long fileSize;
    private final int bufferSize;

    public PathContentProvider(Path filePath) throws IOException {
        this(filePath, 4096);
    }

    public PathContentProvider(Path filePath, int bufferSize) throws IOException {
        if (!Files.isRegularFile(filePath, new LinkOption[0])) {
            throw new NoSuchFileException(filePath.toString());
        }
        if (!Files.isReadable(filePath)) {
            throw new AccessDeniedException(filePath.toString());
        }
        this.filePath = filePath;
        this.fileSize = Files.size(filePath);
        this.bufferSize = bufferSize;
    }

    @Override
    public long getLength() {
        return this.fileSize;
    }

    @Override
    public Iterator<ByteBuffer> iterator() {
        return new Iterator<ByteBuffer>(){
            private final ByteBuffer buffer;
            private SeekableByteChannel channel;
            private long position;
            {
                this.buffer = ByteBuffer.allocateDirect(PathContentProvider.this.bufferSize);
            }

            @Override
            public boolean hasNext() {
                return this.position < PathContentProvider.this.getLength();
            }

            @Override
            public ByteBuffer next() {
                try {
                    if (this.channel == null) {
                        this.channel = Files.newByteChannel(PathContentProvider.this.filePath, StandardOpenOption.READ);
                    }
                    this.buffer.clear();
                    int read = this.channel.read(this.buffer);
                    if (read < 0) {
                        throw new NoSuchElementException();
                    }
                    this.position += (long)read;
                    this.buffer.flip();
                    return this.buffer;
                }
                catch (IOException x) {
                    throw (NoSuchElementException)new NoSuchElementException().initCause(x);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

