/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.util;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.ovea.tajin.framework.io.Resource;
import com.ovea.tajin.framework.util.MissingPropertySettingException;
import com.ovea.tajin.framework.util.PropertyPlaceholderResolver;
import com.ovea.tajin.framework.util.SystemPropertiesMode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public final class PropertySettings {
    private final PropertyPlaceholderResolver resolver = new PropertyPlaceholderResolver();
    private final Properties properties;

    public PropertySettings() {
        this(new Properties());
    }

    public PropertySettings(Properties properties) {
        this.properties = properties;
        this.resolver.setSystemPropertiesMode(SystemPropertiesMode.OVERRIDE);
    }

    public PropertySettings(Resource resource) {
        if (!resource.isExist()) {
            throw new IllegalArgumentException("Inexisting resource: " + resource);
        }
        InputStream is = resource.getInput();
        this.properties = new Properties();
        try {
            try {
                this.properties.load(is);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Unreadable resource: " + resource);
            }
        }
        catch (Throwable throwable) {
            try {
                is.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            is.close();
        }
        catch (IOException iOException) {}
        this.resolver.setSystemPropertiesMode(SystemPropertiesMode.OVERRIDE);
    }

    public PropertySettings plus(Map<String, String> m) {
        this.properties.putAll(m);
        return this;
    }

    public File getPath(String key) {
        return new File(this.getRequired(key));
    }

    public File getPath(String key, File def) {
        String v = this.resolve(key);
        return v == null ? def : new File(v);
    }

    public String getString(String key) {
        return this.getRequired(key);
    }

    public String getString(String key, String def) {
        String v = this.resolve(key);
        return v == null ? def : v;
    }

    public List<String> getStrings(String key) {
        return this.split(this.getRequired(key));
    }

    public List<String> getStrings(String key, String ... def) {
        String v = this.resolve(key);
        return v == null ? Arrays.asList(def) : this.split(v);
    }

    public List<String> getStrings(String key, List<String> def) {
        String v = this.resolve(key);
        return v == null ? def : this.split(v);
    }

    private List<String> split(String s) {
        return Lists.newArrayList(Iterables.transform(Lists.newArrayList(s.split(",|;")), new Function<String, String>(){

            @Override
            public String apply(String input) {
                return input.trim();
            }
        }));
    }

    public Resource getResource(String key) {
        return Resource.resource(this.getRequired(key));
    }

    public Resource getResource(String key, String def) {
        String v = this.resolve(key);
        return Resource.resource(v == null ? def : v);
    }

    private String getRequired(String key) throws MissingPropertySettingException {
        String v = this.resolve(key);
        if (v == null) {
            throw new MissingPropertySettingException(key);
        }
        return v;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String toString() {
        return this.properties.toString();
    }

    private String resolve(String key) {
        return this.resolver.resolve(key, this.properties);
    }

    public long getLong(String key) {
        return Long.parseLong(this.getRequired(key));
    }

    public long getLong(String key, long def) {
        String v = this.resolve(key);
        return v == null ? def : Long.parseLong(v);
    }

    public int getInt(String key) {
        return Integer.parseInt(this.getRequired(key));
    }

    public int getInt(String key, int def) {
        String v = this.resolve(key);
        return v == null ? def : Integer.parseInt(v);
    }

    public boolean getBoolean(String key) {
        return Boolean.valueOf(this.getRequired(key));
    }

    public boolean getBoolean(String key, boolean def) {
        String v = this.resolve(key);
        return v == null ? def : Boolean.valueOf(v);
    }

    public <E extends Enum<E>> E getEnum(Class<E> type, String key) {
        return Enum.valueOf(type, this.getRequired(key));
    }

    public <E extends Enum<E>> E getEnum(Class<E> type, String key, E def) {
        String v = this.resolve(key);
        return v == null ? def : Enum.valueOf(type, v);
    }

    public boolean has(String key) {
        return this.resolve(key) != null;
    }
}

