/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.template;

import com.google.common.collect.Iterables;
import com.google.inject.MembersInjector;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import com.mycila.guice.ext.injection.Reflect;
import com.ovea.tajin.framework.template.I18NTemplate;
import com.ovea.tajin.framework.template.Template;
import com.ovea.tajin.framework.template.TemplateResolver;
import java.lang.reflect.Field;

public final class TmplHandler
implements TypeListener {
    @Override
    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
        final Iterable<Field> fields = Reflect.findAllAnnotatedFields(type.getRawType(), Template.class);
        if (!Iterables.isEmpty(fields)) {
            final Provider<TemplateResolver> resolver = encounter.getProvider(TemplateResolver.class);
            encounter.register(new MembersInjector<I>(){

                @Override
                public void injectMembers(I instance) {
                    for (Field field : fields) {
                        Template annotation = field.getAnnotation(Template.class);
                        I18NTemplate tmpl = new I18NTemplate((TemplateResolver)resolver.get(), annotation.value());
                        if (!field.getType().isAssignableFrom(I18NTemplate.class)) {
                            throw new IllegalStateException("Field " + field + " must be of type " + I18NTemplate.class.getName());
                        }
                        if (!field.isAccessible()) {
                            field.setAccessible(true);
                        }
                        try {
                            field.set(instance, tmpl);
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e.getMessage(), e);
                        }
                    }
                }
            });
        }
    }
}

