/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.jmx;

import com.ovea.tajin.framework.jmx.Signature;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;

public final class ReflectionUtils {
    private static final Map<Class<?>, Reference<Collection<Method>>> declaredMethods = new WeakHashMap();

    private ReflectionUtils() {
    }

    public static boolean isSetter(Method method) {
        return method != null && method.getName().startsWith("set") && method.getParameterTypes().length == 1 && method.getReturnType() == Void.TYPE;
    }

    public static boolean isGetter(Method method) {
        return ReflectionUtils.isGetMethod(method) || ReflectionUtils.isIsMethod(method);
    }

    public static boolean isGetMethod(Method method) {
        return method != null && method.getParameterTypes().length == 0 && method.getReturnType() != Void.TYPE && method.getName().startsWith("get");
    }

    public static boolean isIsMethod(Method method) {
        return method != null && method.getParameterTypes().length == 0 && (method.getReturnType() == Boolean.TYPE || method.getReturnType() == Boolean.class) && method.getName().startsWith("is");
    }

    public static Collection<Method> getDeclaredMethods(Class<?> clazz) {
        Collection<Method> list;
        Reference<Collection<Method>> ref = declaredMethods.get(clazz);
        if (ref != null && (list = ref.get()) != null) {
            return list;
        }
        LinkedHashMap<Signature, Method> signatureMethod = new LinkedHashMap<Signature, Method>();
        while (clazz != null) {
            Method[] methods;
            Method[] methodArray = methods = clazz.isInterface() ? clazz.getMethods() : clazz.getDeclaredMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                Signature signature = new Signature(method);
                if (!(method.isSynthetic() || method.isBridge() || signatureMethod.containsKey(signature))) {
                    signatureMethod.put(signature, method);
                }
                ++n2;
            }
            clazz = clazz.getSuperclass();
        }
        list = signatureMethod.values();
        declaredMethods.put(clazz, new WeakReference(list));
        return list;
    }

    public static Field findField(Class<?> clazz, String name) {
        return ReflectionUtils.findField(clazz, name, null);
    }

    public static Field findField(Class<?> clazz, String name, Class<?> type) {
        Class<?> searchType = clazz;
        while (!Object.class.equals(searchType) && searchType != null) {
            Field[] fields;
            Field[] fieldArray = fields = searchType.getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if ((name == null || name.equals(field.getName())) && (type == null || type.equals(field.getType()))) {
                    return field;
                }
                ++n2;
            }
            searchType = searchType.getSuperclass();
        }
        return null;
    }

    public static Method findMethod(Class<?> clazz, String name) {
        return ReflectionUtils.findMethod(clazz, name, null, new Class[0]);
    }

    public static Method findMethod(Class<?> clazz, String name, Class<?> returnType) {
        return ReflectionUtils.findMethod(clazz, name, returnType, null);
    }

    public static Method findMethod(Class<?> clazz, String name, Class<?> returnType, Class<?> ... paramTypes) {
        if (paramTypes != null && paramTypes.length == 1 && paramTypes[0] == null) {
            paramTypes = null;
        }
        while (clazz != null) {
            Method[] methods;
            Method[] methodArray = methods = clazz.isInterface() ? clazz.getMethods() : clazz.getDeclaredMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (name.equals(method.getName()) && (returnType == null || method.getReturnType().equals(returnType)) && (paramTypes == null || Arrays.equals(paramTypes, method.getParameterTypes()))) {
                    return method;
                }
                ++n2;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }
}

