/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.jmx;

import com.ovea.tajin.framework.jmx.Access;
import com.ovea.tajin.framework.jmx.BeanProperty;
import com.ovea.tajin.framework.jmx.ClassUtils;
import com.ovea.tajin.framework.jmx.JmxAttribute;
import com.ovea.tajin.framework.jmx.JmxUtils;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ReflectionException;
import javax.management.modelmbean.ModelMBeanAttributeInfo;

public final class MBeanProperty<T>
implements JmxAttribute<T> {
    private final BeanProperty<T> beanProperty;
    private final ModelMBeanAttributeInfo attributeInfo;

    public MBeanProperty(BeanProperty<T> beanProperty, String exportName, String description, Access access) {
        this.beanProperty = beanProperty;
        try {
            this.attributeInfo = new ModelMBeanAttributeInfo(exportName, description, access == Access.RO || access == Access.RW ? beanProperty.getReadMethod() : null, access == Access.WO || access == Access.RW ? beanProperty.getWriteMethod() : null);
        }
        catch (IntrospectionException e) {
            throw new IllegalArgumentException("Error creating property from " + beanProperty + ": " + e.getMessage(), e);
        }
    }

    @Override
    public String getName() {
        return this.getMetadata().getName();
    }

    @Override
    public ModelMBeanAttributeInfo getMetadata() {
        return this.attributeInfo;
    }

    @Override
    public T get(Object managedResource) throws ReflectionException {
        if (!this.getMetadata().isReadable()) {
            throw new ReflectionException(new IllegalAccessException("Property not readable: " + this), "Property not readable: " + this);
        }
        try {
            return this.beanProperty.get(managedResource);
        }
        catch (Throwable e) {
            throw JmxUtils.rethrow(e);
        }
    }

    @Override
    public void set(Object managedResource, T value) throws InvalidAttributeValueException, ReflectionException {
        if (!this.getMetadata().isWritable()) {
            throw new ReflectionException(new IllegalAccessException("Property not writable: " + this), "Property not writable: " + this);
        }
        if (!ClassUtils.isAssignableValue(this.beanProperty.getType(), value)) {
            throw new InvalidAttributeValueException("Invalid type specified for property " + this + ": " + value);
        }
        try {
            this.beanProperty.set(managedResource, value);
        }
        catch (Throwable e) {
            throw JmxUtils.rethrow(e);
        }
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MBeanProperty that = (MBeanProperty)o;
        return this.beanProperty.equals(that.beanProperty);
    }

    public int hashCode() {
        return this.beanProperty.hashCode();
    }
}

