/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.jmx;

import com.ovea.tajin.framework.jmx.JmxOperation;
import com.ovea.tajin.framework.jmx.JmxUtils;
import com.ovea.tajin.framework.jmx.Signature;
import java.lang.reflect.Method;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import javax.management.modelmbean.ModelMBeanOperationInfo;

public final class MBeanOperation<T>
implements JmxOperation<T> {
    private final Signature signature;
    private final Method operation;
    private final ModelMBeanOperationInfo operationInfo;

    public MBeanOperation(Method operation, String exportName, String description, MBeanParameterInfo ... parameters) {
        this.operation = operation;
        this.signature = new Signature(operation);
        this.operationInfo = new ModelMBeanOperationInfo(exportName, description, parameters, operation.getReturnType().getName(), 3);
    }

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    @Override
    public ModelMBeanOperationInfo getMetadata() {
        return this.operationInfo;
    }

    @Override
    public T invoke(Object managedResource, Object ... params) throws ReflectionException {
        try {
            return (T)this.operation.invoke(managedResource, params);
        }
        catch (Throwable e) {
            throw JmxUtils.rethrow(e);
        }
    }

    public String toString() {
        return this.getMetadata().getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MBeanOperation that = (MBeanOperation)o;
        return this.signature.equals(that.signature);
    }

    public int hashCode() {
        return this.signature.hashCode();
    }
}

