/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.jmx;

import com.ovea.tajin.framework.jmx.ClassUtils;
import com.ovea.tajin.framework.jmx.JmxAttribute;
import com.ovea.tajin.framework.jmx.JmxMetadata;
import com.ovea.tajin.framework.jmx.JmxOperation;
import com.ovea.tajin.framework.jmx.OperationNotFoundException;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;

public final class DefaultDynamicMBean
implements DynamicMBean {
    private final Object managedResource;
    private final JmxMetadata jmxMetadata;

    public DefaultDynamicMBean(Object managedResource, JmxMetadata jmxMetadata) {
        this.managedResource = managedResource;
        this.jmxMetadata = jmxMetadata;
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attributeName must not be null"), "Exception occurred trying to get attribute of a " + this.getClass().getSimpleName());
        }
        JmxAttribute<?> attr = this.getJmxMetadata().getAttribute(attribute);
        return attr.get(this.getManagedResource());
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attributeNames must not be null"), "Exception occurred trying to get attributes of a " + this.getClass().getSimpleName());
        }
        AttributeList list = new AttributeList();
        String[] stringArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            if (attribute == null) {
                throw new RuntimeOperationsException(new IllegalArgumentException("attributeName must not be null"), "Exception occurred trying to get attribute of a " + this.getClass().getSimpleName());
            }
            try {
                JmxAttribute<?> attr = this.getJmxMetadata().getAttribute(attribute);
                list.add(new Attribute(attr.getMetadata().getName(), attr.get(this.getManagedResource())));
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
            }
            catch (ReflectionException reflectionException) {}
            ++n2;
        }
        return list;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attribute must not be null"), "Exception occurred trying to set an attribute of a " + this.getClass().getSimpleName());
        }
        JmxAttribute<?> attr = this.getJmxMetadata().getAttribute(attribute.getName());
        attr.set(this.getManagedResource(), attribute.getValue());
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attributes must not be null"), "Exception occurred trying to set attributes of a " + this.getClass().getSimpleName());
        }
        AttributeList list = new AttributeList();
        for (Attribute attribute : attributes.asList()) {
            try {
                JmxAttribute<?> attr = this.getJmxMetadata().getAttribute(attribute.getName());
                attr.set(this.getManagedResource(), attribute.getValue());
                list.add(attribute);
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
            }
            catch (ReflectionException reflectionException) {
            }
            catch (InvalidAttributeValueException invalidAttributeValueException) {}
        }
        return list;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException, RuntimeOperationsException {
        JmxOperation<?> op;
        if (actionName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Method name must not be null"), "An exception occurred while trying to invoke a method on a " + this.getClass().getSimpleName());
        }
        Object o = this.getManagedResource();
        ClassLoader loader = o.getClass().getClassLoader();
        Class[] paramTypes = new Class[signature.length];
        try {
            int i = 0;
            while (i < signature.length) {
                paramTypes[i] = ClassUtils.forName(signature[i], loader);
                ++i;
            }
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException(e, "An exception occurred while trying to invoke a method on a " + this.getClass().getSimpleName());
        }
        try {
            op = this.getJmxMetadata().getOperation(actionName, paramTypes);
        }
        catch (OperationNotFoundException e) {
            throw new RuntimeOperationsException(e, "An exception occurred while trying to find method " + actionName + " on " + this.getClass().getSimpleName());
        }
        return op.invoke(o, params);
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.jmxMetadata.getMBeanInfo();
    }

    public JmxMetadata getJmxMetadata() {
        return this.jmxMetadata;
    }

    public Object getManagedResource() {
        return this.managedResource;
    }
}

