/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.jmx;

import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ReflectionException;

public final class ContextualDynamicMBean
implements DynamicMBean {
    private final DynamicMBean delegate;
    private final ClassLoader classLoader;

    public ContextualDynamicMBean(DynamicMBean delegate, ClassLoader context) {
        this.delegate = delegate;
        this.classLoader = context;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public DynamicMBean getDelegate() {
        return this.delegate;
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClassLoader());
            Object object = this.getDelegate().getAttribute(attribute);
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClassLoader());
            AttributeList attributeList = this.getDelegate().getAttributes(attributes);
            return attributeList;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClassLoader());
            this.getDelegate().setAttribute(attribute);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClassLoader());
            AttributeList attributeList = this.getDelegate().setAttributes(attributes);
            return attributeList;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClassLoader());
            Object object = this.getDelegate().invoke(actionName, params, signature);
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.getDelegate().getMBeanInfo();
    }
}

