/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.i18n;

import com.google.common.collect.Iterables;
import com.google.inject.MembersInjector;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import com.mycila.guice.ext.injection.Reflect;
import com.ovea.tajin.framework.i18n.Bundle;
import com.ovea.tajin.framework.i18n.I18NService;
import com.ovea.tajin.framework.i18n.I18NServiceFactory;
import java.lang.reflect.Field;

public final class I18NHandler
implements TypeListener {
    @Override
    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
        final Iterable<Field> fields = Reflect.findAllAnnotatedFields(type.getRawType(), Bundle.class);
        if (!Iterables.isEmpty(fields)) {
            final Provider<I18NServiceFactory> factory = encounter.getProvider(I18NServiceFactory.class);
            encounter.register(new MembersInjector<I>(){

                @Override
                public void injectMembers(I instance) {
                    for (Field field : fields) {
                        Bundle annotation = field.getAnnotation(Bundle.class);
                        I18NService service = ((I18NServiceFactory)factory.get()).forBundle(annotation.value());
                        if (!field.getType().isAssignableFrom(I18NService.class)) {
                            throw new IllegalStateException("Field " + field + " must be of type " + I18NService.class.getName());
                        }
                        if (!field.isAccessible()) {
                            field.setAccessible(true);
                        }
                        try {
                            field.set(instance, service);
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e.getMessage(), e);
                        }
                    }
                }
            });
        }
    }
}

