/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.guice.ext.injection;

import com.google.common.collect.Lists;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.MembersInjector;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import com.mycila.guice.ext.injection.KeyProvider;
import com.mycila.guice.ext.injection.MethodInvoker;
import com.mycila.guice.ext.injection.MycilaGuiceException;
import com.mycila.guice.ext.injection.Reflect;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;

public class MemberInjectorTypeListener<A extends Annotation>
implements TypeListener {
    private final Class<A> annotationType;
    private final Class<? extends KeyProvider<A>> providerClass;

    public MemberInjectorTypeListener(Class<A> annotationType, Class<? extends KeyProvider<A>> providerClass) {
        this.annotationType = annotationType;
        this.providerClass = providerClass;
    }

    @Override
    public <I> void hear(final TypeLiteral<I> injectableType, TypeEncounter<I> encounter) {
        final Provider<? extends KeyProvider<A>> provider = encounter.getProvider(this.providerClass);
        final Provider<Injector> injectorProvider = encounter.getProvider(Injector.class);
        final LinkedList<Field> fields = Lists.newLinkedList(Reflect.findAllAnnotatedFields(injectableType.getRawType(), this.annotationType));
        final LinkedList<MethodInvoker> methods = Lists.newLinkedList(Reflect.findAllAnnotatedInvokables(injectableType.getRawType(), this.annotationType));
        if (!fields.isEmpty() || !methods.isEmpty()) {
            encounter.register(new MembersInjector<I>(){

                @Override
                public void injectMembers(I injectee) {
                    KeyProvider keyProvider = (KeyProvider)provider.get();
                    for (Field field : fields) {
                        Object value = ((Injector)injectorProvider.get()).getProvider(keyProvider.getKey(injectableType, field, field.getAnnotation(MemberInjectorTypeListener.this.annotationType))).get();
                        if (!field.isAccessible()) {
                            field.setAccessible(true);
                        }
                        try {
                            field.set(injectee, value);
                        }
                        catch (IllegalAccessException e) {
                            throw new IllegalStateException("Failed to inject field " + field + ". Reason: " + e.getMessage(), e);
                        }
                    }
                    for (MethodInvoker invokable : methods) {
                        List<Key<?>> parameterKeys = keyProvider.getParameterKeys(injectableType, invokable.method, invokable.getAnnotation(MemberInjectorTypeListener.this.annotationType));
                        Object[] parameters = new Object[parameterKeys.size()];
                        int i = 0;
                        while (i < parameters.length) {
                            parameters[i] = ((Injector)injectorProvider.get()).getProvider(parameterKeys.get(i)).get();
                            ++i;
                        }
                        try {
                            invokable.invoke(injectee, parameters);
                        }
                        catch (Exception e) {
                            throw MycilaGuiceException.toRuntime(e);
                        }
                    }
                }
            });
        }
    }
}

