/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.template.web;

import com.ovea.tajin.framework.template.web.MarkupData;
import com.ovea.tajin.framework.template.web.MarkupOptions;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

final class CachingFixture {
    private final MarkupOptions markupOptions;

    CachingFixture(MarkupOptions markupOptions) {
        this.markupOptions = markupOptions;
    }

    boolean isModified(HttpServletRequest request, HttpServletResponse response, MarkupData markupData) {
        if (!this.markupOptions.dynamic && !this.markupOptions.debug && this.markupOptions.clientCaching > 0L) {
            String etag = request.getHeader("If-None-Match");
            if (markupData.tag.equals(etag)) {
                response.setStatus(304);
                return false;
            }
            long clientLastModified = request.getDateHeader("If-Modified-Since");
            if (clientLastModified != -1L && clientLastModified >= markupData.when) {
                response.setStatus(304);
                return false;
            }
            response.setHeader("ETag", markupData.tag);
            response.setDateHeader("Last-Modified", markupData.when);
            response.setHeader("Cache-Control", "public, max-age=" + this.markupOptions.clientCaching + ", must-revalidate");
        } else {
            response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate, max-age=0");
            response.setHeader("Pragma", "no-cache");
        }
        return true;
    }
}

