/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.support.guice;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import com.ovea.tajin.framework.support.guice.MethodHandler;
import com.ovea.tajin.framework.util.Reflect;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;

final class MethodHandlerTypeListener<A extends Annotation>
implements TypeListener {
    private final Class<A> annotationType;
    private final Class<? extends MethodHandler<A>> handlerClass;

    public MethodHandlerTypeListener(Class<A> annotationType, Class<? extends MethodHandler<A>> handlerClass) {
        this.annotationType = annotationType;
        this.handlerClass = handlerClass;
    }

    @Override
    public <I> void hear(final TypeLiteral<I> type, TypeEncounter<I> encounter) {
        final Provider<? extends MethodHandler<A>> provider = encounter.getProvider(this.handlerClass);
        final List<Method> methods = Lists.reverse(Lists.newLinkedList(Iterables.filter(Reflect.findMethods(type.getRawType()), Reflect.annotatedBy(this.annotationType))));
        if (!methods.isEmpty()) {
            encounter.register(new InjectionListener<I>(){

                @Override
                public void afterInjection(I injectee) {
                    MethodHandler handler = (MethodHandler)provider.get();
                    for (Method method : methods) {
                        handler.handle(type, injectee, method, method.getAnnotation(MethodHandlerTypeListener.this.annotationType));
                    }
                }
            });
        }
    }
}

