/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.support.guice;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import com.ovea.tajin.framework.support.guice.AnnotatedMember;
import com.ovea.tajin.framework.support.guice.AnnotatedMemberHandler;
import com.ovea.tajin.framework.util.Reflect;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedList;

final class AnnotatedMemberHandlerTypeListener<A extends Annotation>
implements TypeListener {
    private final Class<A> annotationType;
    private final Class<? extends AnnotatedMemberHandler<A>> handlerClass;

    public AnnotatedMemberHandlerTypeListener(Class<A> annotationType, Class<? extends AnnotatedMemberHandler<A>> handlerClass) {
        this.annotationType = annotationType;
        this.handlerClass = handlerClass;
    }

    @Override
    public <I> void hear(final TypeLiteral<I> type, TypeEncounter<I> encounter) {
        final Provider<? extends AnnotatedMemberHandler<A>> provider = encounter.getProvider(this.handlerClass);
        final LinkedList<Field> fields = Lists.newLinkedList(Reflect.findFields(type.getRawType(), Reflect.annotatedBy(this.annotationType)));
        final LinkedList<Method> methods = Lists.newLinkedList(Iterables.filter(Reflect.findMethods(type.getRawType()), Reflect.annotatedBy(this.annotationType)));
        if (!fields.isEmpty() || !methods.isEmpty()) {
            encounter.register(new InjectionListener<I>(){

                @Override
                public void afterInjection(I injectee) {
                    AnnotatedMemberHandler handler = (AnnotatedMemberHandler)provider.get();
                    for (Field field : fields) {
                        handler.handle(type, injectee, new AnnotatedMember<Field>(field), field.getAnnotation(AnnotatedMemberHandlerTypeListener.this.annotationType));
                    }
                    for (Method method : methods) {
                        handler.handle(type, injectee, new AnnotatedMember<Method>(method), method.getAnnotation(AnnotatedMemberHandlerTypeListener.this.annotationType));
                    }
                }
            });
        }
    }
}

