/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.i18n;

import com.ovea.tajin.framework.i18n.I18NBundle;
import com.ovea.tajin.framework.i18n.I18NBundleSkeleton;
import com.ovea.tajin.framework.i18n.I18NServiceSkeleton;
import com.ovea.tajin.framework.i18n.MissingMessageException;
import com.ovea.tajin.framework.io.Resource;
import com.ovea.tajin.framework.template.TemplateResolverException;
import groovy.json.JsonSlurper;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JsonI18NService
extends I18NServiceSkeleton {
    private static final Logger LOGGER = Logger.getLogger(JsonI18NService.class.getName());

    public JsonI18NService(String bundleName) {
        super(bundleName);
    }

    @Override
    I18NBundle newBundle(String bundleName, Locale locale) {
        return new I18NBundleSkeleton(bundleName, locale, this.getMissingKeyBehaviour()){
            volatile Properties mappings;

            @Override
            public List<String> keys() {
                return new LinkedList<String>(this.getMappings().stringPropertyNames());
            }

            @Override
            public boolean hasKey(String key) {
                return this.getMappings().containsKey(key);
            }

            @Override
            String getValue(String key) throws MissingMessageException {
                return this.getMappings().getProperty(key);
            }

            private Properties getMappings() {
                if (this.mappings == null) {
                    if (JsonI18NService.this.isDebug()) {
                        return this.load();
                    }
                    this.mappings = this.load();
                }
                return this.mappings;
            }

            private Properties load() {
                Properties all = new Properties();
                this.load(all, "");
                String str = this.locale().toString();
                if (str.length() >= 2) {
                    this.load(all, str.substring(0, 2));
                }
                if (str.length() >= 5) {
                    this.load(all, str.substring(0, 5));
                }
                return all;
            }

            private void load(Properties target, String locale) {
                block4: {
                    Resource resource = null;
                    try {
                        String b = this.bundleName();
                        int pos = b.lastIndexOf(46);
                        if (pos == -1) {
                            throw new TemplateResolverException("Illegal bundle name: extension needed");
                        }
                        resource = Resource.resource(b.substring(0, pos) + (locale.length() > 0 ? "_" + locale : locale) + b.substring(pos));
                        String content = resource.getText();
                        if (content.length() > 0) {
                            JsonI18NService.parse(target, (Map)new JsonSlurper().parseText(content), "");
                        }
                    }
                    catch (RuntimeException e) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block4;
                        LOGGER.fine("Cannot find resource " + resource);
                    }
                }
            }
        };
    }

    private static void parse(Properties target, Map<String, Object> object, String completeKey) {
        for (String key : object.keySet()) {
            String ck;
            Object o = object.get(key);
            String string = ck = completeKey.length() > 0 ? completeKey + "." + key : key;
            if (o instanceof Map) {
                JsonI18NService.parse(target, (Map)o, ck);
                continue;
            }
            if (o instanceof Collection) {
                target.put(ck, o.toString());
                continue;
            }
            if (o == null) continue;
            target.put(ck, String.valueOf(o));
        }
    }
}

