/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.i18n;

import com.ovea.tajin.framework.i18n.I18NBundle;
import com.ovea.tajin.framework.i18n.I18NBundleSkeleton;
import com.ovea.tajin.framework.i18n.I18NServiceSkeleton;
import com.ovea.tajin.framework.i18n.MissingMessageException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class DefaultI18NService
extends I18NServiceSkeleton {
    public DefaultI18NService(String bundleName) {
        super(bundleName);
    }

    @Override
    I18NBundle newBundle(String bundleName, Locale locale) {
        return new I18NBundleSkeleton(bundleName, locale, this.getMissingKeyBehaviour()){
            ResourceBundle bundle;

            @Override
            public List<String> keys() {
                LinkedList<String> keys = new LinkedList<String>();
                Enumeration<String> enu = this.getBundle().getKeys();
                while (enu.hasMoreElements()) {
                    keys.add(enu.nextElement());
                }
                return keys;
            }

            @Override
            public boolean hasKey(String key) {
                return this.getBundle().containsKey(key);
            }

            @Override
            String getValue(String key) throws MissingMessageException {
                try {
                    return this.getBundle().getString(key);
                }
                catch (MissingResourceException e) {
                    return null;
                }
            }

            private ResourceBundle getBundle() {
                String b = this.bundleName();
                if (b.endsWith(".properties")) {
                    b = b.substring(0, b.length() - 11);
                }
                if (DefaultI18NService.this.isDebug()) {
                    ResourceBundle.clearCache(this.loader);
                    return ResourceBundle.getBundle(b, this.locale(), this.loader);
                }
                if (this.bundle == null) {
                    this.bundle = ResourceBundle.getBundle(b, this.locale(), this.loader);
                }
                return this.bundle;
            }
        };
    }
}

