/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.jmx;

import com.mycila.jmx.AopUtils;
import com.mycila.jmx.ClassUtils;
import com.mycila.jmx.JmxNamingStrategy;
import com.mycila.jmx.JmxSelfNaming;
import com.mycila.jmx.JmxUtils;
import com.mycila.jmx.StringUtils;
import com.mycila.jmx.annotation.JmxBean;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class MBeanNamingStrategy
implements JmxNamingStrategy {
    private final boolean ensureUniqueObjectNames;

    public MBeanNamingStrategy() {
        this(false);
    }

    public MBeanNamingStrategy(boolean ensureUniqueObjectNames) {
        this.ensureUniqueObjectNames = ensureUniqueObjectNames;
    }

    @Override
    public ObjectName getObjectName(Object managedBean) throws MalformedObjectNameException {
        ObjectName objectName = this.getObjectNameInternal(managedBean);
        return this.ensureUniqueObjectNames ? JmxUtils.appendIdentityToObjectName(objectName, managedBean) : objectName;
    }

    protected ObjectName getObjectNameInternal(Object managedBean) throws MalformedObjectNameException {
        Class<?> managedClass = AopUtils.getTargetClass(managedBean);
        if (managedBean instanceof JmxSelfNaming) {
            return ((JmxSelfNaming)managedBean).getObjectName();
        }
        JmxBean jmxBean = managedClass.getAnnotation(JmxBean.class);
        if (jmxBean != null) {
            if (StringUtils.hasLength(jmxBean.objectName())) {
                return ObjectName.getInstance(jmxBean.objectName());
            }
            if (StringUtils.hasLength(jmxBean.value())) {
                return ObjectName.getInstance(jmxBean.value());
            }
        }
        return ObjectName.getInstance(String.valueOf(ClassUtils.getPackageName(managedClass)) + ":type=" + ClassUtils.getShortName(managedClass));
    }
}

