/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.guice.ext.service;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.lang.reflect.Array;
import java.util.LinkedList;
import java.util.ServiceLoader;

public class MultiServiceProvider<T>
implements Provider<T[]> {
    @Inject
    private Injector injector;
    private final Class<T> type;
    private final ClassLoader classLoader;

    public MultiServiceProvider(Class<T> type) {
        this(type, type.getClassLoader());
    }

    public MultiServiceProvider(Class<T> type, ClassLoader classLoader) {
        this.type = type;
        this.classLoader = classLoader;
    }

    @Override
    public T[] get() {
        LinkedList<T> instances = new LinkedList<T>();
        for (T instance : ServiceLoader.load(this.type, this.classLoader)) {
            this.injector.injectMembers(instance);
            instances.add(instance);
        }
        Object[] array = (Object[])Array.newInstance(this.type, instances.size());
        return instances.toArray(array);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.type.getName() + "]";
    }
}

