/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.servlet.ServletDefinition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

@Singleton
class ManagedServletPipeline {
    private final ServletDefinition[] servletDefinitions;
    private static final TypeLiteral<ServletDefinition> SERVLET_DEFS = TypeLiteral.get(ServletDefinition.class);
    public static final String REQUEST_DISPATCHER_REQUEST = "javax.servlet.forward.servlet_path";

    @Inject
    public ManagedServletPipeline(Injector injector) {
        this.servletDefinitions = this.collectServletDefinitions(injector);
    }

    boolean hasServletsMapped() {
        return this.servletDefinitions.length > 0;
    }

    private ServletDefinition[] collectServletDefinitions(Injector injector) {
        ArrayList<ServletDefinition> servletDefinitions = Lists.newArrayList();
        for (Binding<ServletDefinition> entry : injector.findBindingsByType(SERVLET_DEFS)) {
            servletDefinitions.add(entry.getProvider().get());
        }
        return servletDefinitions.toArray(new ServletDefinition[servletDefinitions.size()]);
    }

    public void init(ServletContext servletContext, Injector injector) throws ServletException {
        Set<HttpServlet> initializedSoFar = Sets.newSetFromMap(Maps.newIdentityHashMap());
        ServletDefinition[] servletDefinitionArray = this.servletDefinitions;
        int n = this.servletDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            ServletDefinition servletDefinition = servletDefinitionArray[n2];
            servletDefinition.init(servletContext, injector, initializedSoFar);
            ++n2;
        }
    }

    public boolean service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        ServletDefinition[] servletDefinitionArray = this.servletDefinitions;
        int n = this.servletDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            ServletDefinition servletDefinition = servletDefinitionArray[n2];
            if (servletDefinition.service(request, response)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void destroy() {
        Set<HttpServlet> destroyedSoFar = Sets.newSetFromMap(Maps.newIdentityHashMap());
        ServletDefinition[] servletDefinitionArray = this.servletDefinitions;
        int n = this.servletDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            ServletDefinition servletDefinition = servletDefinitionArray[n2];
            servletDefinition.destroy(destroyedSoFar);
            ++n2;
        }
    }

    RequestDispatcher getRequestDispatcher(String path) {
        final String newRequestUri = path;
        ServletDefinition[] servletDefinitionArray = this.servletDefinitions;
        int n = this.servletDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            final ServletDefinition servletDefinition = servletDefinitionArray[n2];
            if (servletDefinition.shouldServe(path)) {
                return new RequestDispatcher(){

                    @Override
                    public void forward(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
                        Preconditions.checkState(!servletResponse.isCommitted(), "Response has been committed--you can only call forward before committing the response (hint: don't flush buffers)");
                        servletResponse.resetBuffer();
                        ServletRequest requestToProcess = servletRequest instanceof HttpServletRequest ? new RequestDispatcherRequestWrapper(servletRequest, newRequestUri) : servletRequest;
                        servletRequest.setAttribute(ManagedServletPipeline.REQUEST_DISPATCHER_REQUEST, Boolean.TRUE);
                        try {
                            servletDefinition.doService(requestToProcess, servletResponse);
                        }
                        finally {
                            servletRequest.removeAttribute(ManagedServletPipeline.REQUEST_DISPATCHER_REQUEST);
                        }
                    }

                    @Override
                    public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
                        servletRequest.setAttribute(ManagedServletPipeline.REQUEST_DISPATCHER_REQUEST, Boolean.TRUE);
                        try {
                            servletDefinition.doService(servletRequest, servletResponse);
                        }
                        finally {
                            servletRequest.removeAttribute(ManagedServletPipeline.REQUEST_DISPATCHER_REQUEST);
                        }
                    }
                };
            }
            ++n2;
        }
        return null;
    }

    private static class RequestDispatcherRequestWrapper
    extends HttpServletRequestWrapper {
        private final String newRequestUri;

        public RequestDispatcherRequestWrapper(ServletRequest servletRequest, String newRequestUri) {
            super((HttpServletRequest)servletRequest);
            this.newRequestUri = newRequestUri;
        }

        @Override
        public String getRequestURI() {
            return this.newRequestUri;
        }
    }
}

