/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.statistic.CounterStatistic;
import org.eclipse.jetty.util.statistic.SampleStatistic;

@ManagedObject(value="Connector Statistics")
public class ConnectorStatistics
extends AbstractLifeCycle
implements Dumpable,
Connection.Listener {
    private final AtomicLong _startMillis = new AtomicLong(-1L);
    private final CounterStatistic _connectionStats = new CounterStatistic();
    private final SampleStatistic _messagesIn = new SampleStatistic();
    private final SampleStatistic _messagesOut = new SampleStatistic();
    private final SampleStatistic _connectionDurationStats = new SampleStatistic();

    @Override
    public void onOpened(Connection connection) {
        this.connectionOpened();
    }

    @Override
    public void onClosed(Connection connection) {
        this.connectionClosed(System.currentTimeMillis() - connection.getCreatedTimeStamp(), connection.getMessagesIn(), connection.getMessagesOut());
    }

    @ManagedAttribute(value="Total number of bytes received by this connector")
    public int getBytesIn() {
        return -1;
    }

    @ManagedAttribute(value="Total number of bytes sent by this connector")
    public int getBytesOut() {
        return -1;
    }

    @ManagedAttribute(value="Total number of connections seen by this connector")
    public int getConnections() {
        return (int)this._connectionStats.getTotal();
    }

    @ManagedAttribute(value="Connection duraton maximum in ms")
    public long getConnectionsDurationMax() {
        return this._connectionDurationStats.getMax();
    }

    @ManagedAttribute(value="Connection duraton mean in ms")
    public double getConnectionsDurationMean() {
        return this._connectionDurationStats.getMean();
    }

    @ManagedAttribute(value="Connection duraton standard deviation")
    public double getConnectionsDurationStdDev() {
        return this._connectionDurationStats.getStdDev();
    }

    @ManagedAttribute(value="Connection duraton total of all connections in ms")
    public long getConnectionsDurationTotal() {
        return this._connectionDurationStats.getTotal();
    }

    @ManagedAttribute(value="Messages In for all connections")
    public int getMessagesIn() {
        return (int)this._messagesIn.getTotal();
    }

    @ManagedAttribute(value="Messages In per connection maximum")
    public int getConnectionsMessagesInMax() {
        return (int)this._messagesIn.getMax();
    }

    @ManagedAttribute(value="Messages In per connection mean")
    public double getConnectionsMessagesInMean() {
        return this._messagesIn.getMean();
    }

    @ManagedAttribute(value="Messages In per connection standard deviation")
    public double getConnectionsMessagesInStdDev() {
        return this._messagesIn.getStdDev();
    }

    @ManagedAttribute(value="Connections open")
    public int getConnectionsOpen() {
        return (int)this._connectionStats.getCurrent();
    }

    @ManagedAttribute(value="Connections open maximum")
    public int getConnectionsOpenMax() {
        return (int)this._connectionStats.getMax();
    }

    @ManagedAttribute(value="Messages Out for all connections")
    public int getMessagesOut() {
        return (int)this._messagesIn.getTotal();
    }

    @ManagedAttribute(value="Connection statistics started ms since epoch")
    public long getStartedMillis() {
        long start = this._startMillis.get();
        return start < 0L ? 0L : System.currentTimeMillis() - start;
    }

    @Override
    public void doStart() {
        this.reset();
    }

    @Override
    public void doStop() {
    }

    @ManagedOperation(value="Reset the statistics")
    public void reset() {
        this._startMillis.set(System.currentTimeMillis());
        this._messagesIn.reset();
        this._messagesOut.reset();
        this._connectionStats.reset();
        this._connectionDurationStats.reset();
    }

    public void connectionOpened() {
        if (this.isStarted()) {
            this._connectionStats.increment();
        }
    }

    public void connectionUpgraded(int messagesIn, int messagesOut) {
        if (this.isStarted()) {
            this._messagesIn.set(messagesIn);
            this._messagesOut.set(messagesOut);
        }
    }

    public void connectionClosed(long duration, int messagesIn, int messagesOut) {
        if (this.isStarted()) {
            this._messagesIn.set(messagesIn);
            this._messagesOut.set(messagesOut);
            this._connectionStats.decrement();
            this._connectionDurationStats.set(duration);
        }
    }

    @Override
    @ManagedOperation(value="dump thread state")
    public String dump() {
        return ContainerLifeCycle.dump(this);
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        ContainerLifeCycle.dumpObject(out, this);
        ContainerLifeCycle.dump(out, indent, Arrays.asList("connections=" + this._connectionStats, "duration=" + this._connectionDurationStats, "in=" + this._messagesIn, "out=" + this._messagesOut));
    }

    public static void addToAllConnectors(Server server) {
        for (Connector connector : server.getConnectors()) {
            if (!(connector instanceof Container)) continue;
            ((Container)((Object)connector)).addBean(new ConnectorStatistics());
        }
    }
}

