/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.util;

import com.ovea.tajin.framework.util.SystemPropertiesMode;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class PropertyPlaceholderResolver {
    public static final String DEFAULT_PLACEHOLDER_PREFIX = "${";
    public static final String DEFAULT_PLACEHOLDER_SUFFIX = "}";
    private final String placeholderPrefix = "${";
    private final String placeholderSuffix = "}";
    private boolean ignoreSystemEnvironment = false;
    private boolean ignoreUnresolvablePlaceholders = false;
    private SystemPropertiesMode systemPropertiesMode = SystemPropertiesMode.FALLBACK;

    public void setIgnoreSystemEnvironment(boolean ignoreSystemEnvironment) {
        this.ignoreSystemEnvironment = ignoreSystemEnvironment;
    }

    public void setIgnoreUnresolvablePlaceholders(boolean ignoreUnresolvablePlaceholders) {
        this.ignoreUnresolvablePlaceholders = ignoreUnresolvablePlaceholders;
    }

    public void setSystemPropertiesMode(SystemPropertiesMode systemPropertiesMode) {
        this.systemPropertiesMode = systemPropertiesMode;
    }

    public Properties resolveAll(Properties ... properties) {
        Properties p = new Properties();
        Properties all = new Properties();
        Properties[] propertiesArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            Properties props = propertiesArray[n2];
            all.putAll((Map<?, ?>)props);
            ++n2;
        }
        for (String key : all.stringPropertyNames()) {
            String v = this.parseStringValue(all, all.getProperty(key), new HashSet<String>());
            String k = this.parseStringValue(all, key, new HashSet<String>());
            p.setProperty(k, v);
        }
        return p;
    }

    private String parseStringValue(Properties properties, String strVal, Set<String> visitedPlaceholders) {
        StringBuilder buf = new StringBuilder(strVal);
        int startIndex = strVal.indexOf(DEFAULT_PLACEHOLDER_PREFIX);
        while (startIndex != -1) {
            int endIndex = this.findPlaceholderEndIndex(buf, startIndex);
            if (endIndex != -1) {
                String placeholder = buf.substring(startIndex + DEFAULT_PLACEHOLDER_PREFIX.length(), endIndex);
                if (!visitedPlaceholders.add(placeholder)) {
                    throw new IllegalStateException("Circular placeholder reference '" + placeholder + "' in property definitions");
                }
                String propVal = this.resolvePlaceholder(properties, placeholder = this.parseStringValue(properties, placeholder, visitedPlaceholders), this.systemPropertiesMode);
                if (propVal != null) {
                    propVal = this.parseStringValue(properties, propVal, visitedPlaceholders);
                    buf.replace(startIndex, endIndex + DEFAULT_PLACEHOLDER_SUFFIX.length(), propVal);
                    startIndex = buf.indexOf(DEFAULT_PLACEHOLDER_PREFIX, startIndex + propVal.length());
                } else if (this.ignoreUnresolvablePlaceholders) {
                    startIndex = buf.indexOf(DEFAULT_PLACEHOLDER_PREFIX, endIndex + DEFAULT_PLACEHOLDER_SUFFIX.length());
                } else {
                    throw new IllegalStateException("Could not resolve placeholder '" + placeholder + "'");
                }
                visitedPlaceholders.remove(placeholder);
                continue;
            }
            startIndex = -1;
        }
        return buf.toString();
    }

    private int findPlaceholderEndIndex(CharSequence buf, int startIndex) {
        int index = startIndex + DEFAULT_PLACEHOLDER_PREFIX.length();
        int withinNestedPlaceholder = 0;
        while (index < buf.length()) {
            if (PropertyPlaceholderResolver.substringMatch(buf, index, DEFAULT_PLACEHOLDER_SUFFIX)) {
                if (withinNestedPlaceholder > 0) {
                    --withinNestedPlaceholder;
                    index += DEFAULT_PLACEHOLDER_SUFFIX.length();
                    continue;
                }
                return index;
            }
            if (PropertyPlaceholderResolver.substringMatch(buf, index, DEFAULT_PLACEHOLDER_PREFIX)) {
                ++withinNestedPlaceholder;
                index += DEFAULT_PLACEHOLDER_PREFIX.length();
                continue;
            }
            ++index;
        }
        return -1;
    }

    public String merge(String line, Properties properties) {
        return this.parseStringValue(properties, line, new HashSet<String>());
    }

    public String resolve(String placeholder, Properties properties) {
        return this.resolvePlaceholder(properties, placeholder, this.systemPropertiesMode);
    }

    private String resolvePlaceholder(Properties properties, String placeholder, SystemPropertiesMode mode) {
        String propVal = null;
        if (mode == SystemPropertiesMode.OVERRIDE) {
            propVal = this.resolveSystemProperty(placeholder);
        }
        if (propVal == null) {
            propVal = properties.getProperty(placeholder);
        }
        if (propVal == null && mode == SystemPropertiesMode.FALLBACK) {
            propVal = this.resolveSystemProperty(placeholder);
        }
        return propVal;
    }

    private String resolveSystemProperty(String key) {
        try {
            String value = System.getProperty(key);
            if (value == null && !this.ignoreSystemEnvironment) {
                value = System.getenv(key);
            }
            return value;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    private static boolean substringMatch(CharSequence str, int index, CharSequence substring) {
        int j = 0;
        while (j < substring.length()) {
            int i = index + j;
            if (i >= str.length() || str.charAt(i) != substring.charAt(j)) {
                return false;
            }
            ++j;
        }
        return true;
    }
}

