/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.guice.ext.injection;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.internal.BytecodeGen;
import com.google.inject.internal.cglib.core.$CodeGenerationException;
import com.google.inject.internal.cglib.reflect.$FastMethod;
import com.mycila.guice.ext.injection.MycilaGuiceException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.ExecutionException;

public class MethodInvoker
implements Member,
AnnotatedElement {
    private static final LoadingCache<Method, MethodInvoker> INVOKERS = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Method, MethodInvoker>(){

        @Override
        public MethodInvoker load(Method method) throws Exception {
            int modifiers = method.getModifiers();
            if (!Modifier.isPrivate(modifiers) && !Modifier.isProtected(modifiers)) {
                try {
                    final $FastMethod fastMethod = BytecodeGen.newFastClass(method.getDeclaringClass(), BytecodeGen.Visibility.forMember(method)).getMethod(method);
                    return new MethodInvoker(method){

                        @Override
                        public Object invoke(Object target, Object ... parameters) {
                            try {
                                return fastMethod.invoke(target, parameters);
                            }
                            catch (InvocationTargetException e) {
                                throw MycilaGuiceException.toRuntime(e);
                            }
                        }
                    };
                }
                catch ($CodeGenerationException $CodeGenerationException) {}
            }
            if (!Modifier.isPublic(modifiers) || !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
                method.setAccessible(true);
            }
            return new MethodInvoker(method, null, null);
        }
    });
    public final Method method;

    private MethodInvoker(Method method) {
        this.method = method;
    }

    public Object invoke(Object target, Object ... parameters) {
        try {
            return this.method.invoke(target, parameters);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw MycilaGuiceException.toRuntime(e);
        }
    }

    public static MethodInvoker on(Method method) {
        try {
            return INVOKERS.get(method);
        }
        catch (ExecutionException e) {
            throw MycilaGuiceException.toRuntime(e);
        }
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.method.isAnnotationPresent(annotationClass);
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.method.getAnnotations();
    }

    @Override
    public int getModifiers() {
        return this.method.getModifiers();
    }

    @Override
    public String getName() {
        return this.method.getName();
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.method.getDeclaringClass();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.method.getDeclaredAnnotations();
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.method.getAnnotation(annotationClass);
    }

    @Override
    public boolean isSynthetic() {
        return this.method.isSynthetic();
    }

    public String toString() {
        return this.method.toString();
    }

    /* synthetic */ MethodInvoker(Method method, MethodInvoker methodInvoker) {
        this(method);
    }

    /* synthetic */ MethodInvoker(Method method, MethodInvoker methodInvoker, MethodInvoker methodInvoker2) {
        this(method);
    }
}

