/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.guice.ext.web;

import java.util.Deque;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class HttpContext {
    private static final Logger LOGGER = Logger.getLogger(HttpContext.class.getName());
    private static final ThreadLocal<Deque<HttpContext>> CTX = new ThreadLocal<Deque<HttpContext>>(){

        @Override
        protected Deque<HttpContext> initialValue() {
            return new LinkedList<HttpContext>();
        }
    };
    private final HttpServletRequest request;
    private final HttpServletResponse response;

    private HttpContext(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    public HttpServletRequest request() {
        return this.request;
    }

    public HttpServletResponse response() {
        return this.response;
    }

    public static void change(HttpServletRequest request, HttpServletResponse response) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("[" + request.getRequestURI() + "] Changing HttpContext to request " + request.getClass().getName() + " and response " + response.getClass().getName());
        }
        HttpContext context = new HttpContext(request, response);
        CTX.get().offerFirst(context);
    }

    public static void end() {
        CTX.get().poll();
    }

    public static HttpContext get() {
        try {
            return CTX.get().getFirst();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalStateException("No HttpContext bound to local thread ! Surround your code with HttpContext.enter() or HttpContextFilter !");
        }
    }
}

