/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.guice.ext.injection;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.MembersInjector;
import com.google.inject.Module;
import com.google.inject.PrivateBinder;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.Stage;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.AnnotatedBindingBuilder;
import com.google.inject.binder.AnnotatedConstantBindingBuilder;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.Message;
import com.google.inject.spi.ProvisionListener;
import com.google.inject.spi.TypeConverter;
import com.google.inject.spi.TypeListener;
import com.mycila.guice.ext.injection.FieldHandler;
import com.mycila.guice.ext.injection.FieldHandlerTypeListener;
import com.mycila.guice.ext.injection.KeyProvider;
import com.mycila.guice.ext.injection.MemberInjectorTypeListener;
import com.mycila.guice.ext.injection.MethodHandler;
import com.mycila.guice.ext.injection.MethodHandlerTypeListener;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;

public class MBinder
implements Binder {
    private final Binder binder;

    private MBinder(Binder binder) {
        this.binder = binder;
    }

    public <A extends Annotation> MBinder bindAnnotationInjector(Class<A> annotationType, Class<? extends KeyProvider<A>> providerClass) {
        this.binder.bindListener(Matchers.any(), this.willInject(new MemberInjectorTypeListener<A>(annotationType, providerClass)));
        return this;
    }

    public <A extends Annotation> MBinder handleMethodAfterInjection(Class<A> annotationType, Class<? extends MethodHandler<A>> providerClass) {
        this.binder.bindListener(Matchers.any(), this.willInject(new MethodHandlerTypeListener<A>(annotationType, providerClass)));
        return this;
    }

    public <A extends Annotation> MBinder handleFieldAfterInjection(Class<A> annotationType, Class<? extends FieldHandler<A>> providerClass) {
        this.binder.bindListener(Matchers.any(), this.willInject(new FieldHandlerTypeListener<A>(annotationType, providerClass)));
        return this;
    }

    public <T> T willInject(T object) {
        this.binder.requestInjection(object);
        return object;
    }

    public static MBinder wrap(Binder binder) {
        return new MBinder(binder);
    }

    @Override
    public void addError(Message message) {
        this.binder.addError(message);
    }

    @Override
    public void addError(String message, Object ... arguments) {
        this.binder.addError(message, arguments);
    }

    @Override
    public void addError(Throwable t) {
        this.binder.addError(t);
    }

    @Override
    public <T> LinkedBindingBuilder<T> bind(Key<T> key) {
        return this.binder.bind(key);
    }

    @Override
    public <T> AnnotatedBindingBuilder<T> bind(Class<T> type) {
        return this.binder.bind(type);
    }

    @Override
    public <T> AnnotatedBindingBuilder<T> bind(TypeLiteral<T> typeLiteral) {
        return this.binder.bind(typeLiteral);
    }

    @Override
    public AnnotatedConstantBindingBuilder bindConstant() {
        return this.binder.bindConstant();
    }

    @Override
    public void bindInterceptor(Matcher<? super Class<?>> classMatcher, Matcher<? super Method> methodMatcher, MethodInterceptor ... interceptors) {
        MethodInterceptor[] methodInterceptorArray = interceptors;
        int n = interceptors.length;
        int n2 = 0;
        while (n2 < n) {
            MethodInterceptor interceptor = methodInterceptorArray[n2];
            this.requestInjection(interceptor);
            ++n2;
        }
        this.binder.bindInterceptor(classMatcher, methodMatcher, interceptors);
    }

    @Override
    public void bindListener(Matcher<? super Key<?>> keyMatcher, ProvisionListener ... listeners) {
        this.binder.bindListener(keyMatcher, listeners);
    }

    @Override
    public void bindListener(Matcher<? super TypeLiteral<?>> typeMatcher, TypeListener listener) {
        this.binder.bindListener(typeMatcher, listener);
    }

    @Override
    public void bindScope(Class<? extends Annotation> annotationType, Scope scope) {
        this.binder.bindScope(annotationType, scope);
    }

    @Override
    public void convertToTypes(Matcher<? super TypeLiteral<?>> typeMatcher, TypeConverter converter) {
        this.binder.convertToTypes(typeMatcher, converter);
    }

    @Override
    public Stage currentStage() {
        return this.binder.currentStage();
    }

    @Override
    public void disableCircularProxies() {
        this.binder.disableCircularProxies();
    }

    @Override
    public <T> MembersInjector<T> getMembersInjector(Class<T> type) {
        return this.binder.getMembersInjector(type);
    }

    @Override
    public <T> MembersInjector<T> getMembersInjector(TypeLiteral<T> typeLiteral) {
        return this.binder.getMembersInjector(typeLiteral);
    }

    @Override
    public <T> Provider<T> getProvider(Key<T> key) {
        return this.binder.getProvider(key);
    }

    @Override
    public <T> Provider<T> getProvider(Class<T> type) {
        return this.binder.getProvider(type);
    }

    @Override
    public void install(Module module) {
        this.binder.install(module);
    }

    @Override
    public PrivateBinder newPrivateBinder() {
        return this.binder.newPrivateBinder();
    }

    @Override
    public void requestInjection(Object instance) {
        this.binder.requestInjection(instance);
    }

    @Override
    public <T> void requestInjection(TypeLiteral<T> type, T instance) {
        this.binder.requestInjection(type, instance);
    }

    @Override
    public void requestStaticInjection(Class<?> ... types) {
        this.binder.requestStaticInjection(types);
    }

    @Override
    public void requireExplicitBindings() {
        this.binder.requireExplicitBindings();
    }

    @Override
    public Binder skipSources(Class ... classesToSkip) {
        return this.binder.skipSources(classesToSkip);
    }

    @Override
    public Binder withSource(Object source) {
        return this.binder.withSource(source);
    }
}

