/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.jmx;

import com.mycila.jmx.Access;
import com.mycila.jmx.BeanProperty;
import com.mycila.jmx.JmxAttribute;
import com.mycila.jmx.JmxMetadata;
import com.mycila.jmx.JmxMetadataAssembler;
import com.mycila.jmx.JmxOperation;
import com.mycila.jmx.JmxUtils;
import com.mycila.jmx.MBeanAttribute;
import com.mycila.jmx.MBeanMetadata;
import com.mycila.jmx.MBeanOperation;
import com.mycila.jmx.MBeanProperty;
import com.mycila.jmx.Role;
import com.mycila.jmx.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.LinkedList;
import javax.management.Descriptor;
import javax.management.MBeanParameterInfo;

public abstract class MetadataAssemblerSkeleton
implements JmxMetadataAssembler {
    @Override
    public JmxMetadata getMetadata(Class<?> managedClass) {
        return new MBeanMetadata(managedClass.getName(), this.getMBeanDescription(managedClass), this.getMBeanAttributes(managedClass), this.getMBeanOperations(managedClass));
    }

    protected String getMBeanDescription(Class<?> managedClass) {
        return managedClass.getName();
    }

    protected Collection<JmxAttribute> getMBeanAttributes(Class<?> managedClass) {
        LinkedList<JmxAttribute> jmxAttributes = new LinkedList<JmxAttribute>();
        for (BeanProperty property : this.getProperties(managedClass)) {
            jmxAttributes.add(this.buildProperty(managedClass, property));
        }
        for (Field field : this.getAttributes(managedClass)) {
            jmxAttributes.add(this.buildAttribute(managedClass, field));
        }
        return jmxAttributes;
    }

    protected JmxAttribute buildAttribute(Class<?> managedClass, Field field) {
        MBeanAttribute jmxAttribute = new MBeanAttribute(field, this.getAttributeExportName(managedClass, field), this.getAttributeDescription(managedClass, field), this.getAttributeAccess(managedClass, field));
        Descriptor desc = jmxAttribute.getMetadata().getDescriptor();
        this.populateAttributeDescriptor(managedClass, field, desc);
        jmxAttribute.getMetadata().setDescriptor(desc);
        return jmxAttribute;
    }

    protected JmxAttribute buildProperty(Class<?> managedClass, BeanProperty property) {
        MBeanProperty jmxAttribute = new MBeanProperty(property, this.getPropertyExportName(managedClass, property), this.getPropertyDescription(managedClass, property), this.getPropertyAccess(managedClass, property));
        Descriptor desc = jmxAttribute.getMetadata().getDescriptor();
        this.populatePropertyDescriptor(managedClass, property, desc);
        jmxAttribute.getMetadata().setDescriptor(desc);
        return jmxAttribute;
    }

    protected Collection<JmxOperation> getMBeanOperations(Class<?> managedClass) {
        LinkedList<JmxOperation> jmxOperations = new LinkedList<JmxOperation>();
        for (Method method : this.getMethodOperations(managedClass)) {
            jmxOperations.add(this.buildOperation(managedClass, method));
        }
        return jmxOperations;
    }

    protected JmxOperation buildOperation(Class<?> managedClass, Method operation) {
        MBeanOperation jmxOperation = new MBeanOperation(operation, this.getOperationExportName(managedClass, operation), this.getOperationDescription(managedClass, operation), this.getOperationParameters(managedClass, operation));
        Descriptor desc = jmxOperation.getMetadata().getDescriptor();
        this.populateOperationDescriptor(managedClass, operation, desc);
        jmxOperation.getMetadata().setDescriptor(desc);
        return jmxOperation;
    }

    protected abstract Collection<Field> getAttributes(Class<?> var1);

    protected String getAttributeExportName(Class<?> managedClass, Field attribute) {
        return attribute.getName();
    }

    protected String getAttributeDescription(Class<?> managedClass, Field attribute) {
        return "";
    }

    protected Access getAttributeAccess(Class<?> managedClass, Field attribute) {
        return Modifier.isFinal(attribute.getModifiers()) ? Access.RO : Access.RW;
    }

    protected void populateAttributeDescriptor(Class<?> managedClass, Field attribute, Descriptor desc) {
        JmxUtils.populateDeprecation(desc, attribute);
        JmxUtils.populateEnable(desc, true);
        JmxUtils.populateDisplayName(desc, attribute.getName());
        JmxUtils.populateVisibility(desc, 1);
    }

    protected abstract Collection<BeanProperty> getProperties(Class<?> var1);

    protected String getPropertyExportName(Class<?> managedClass, BeanProperty property) {
        return StringUtils.capitalize(property.getName());
    }

    protected String getPropertyDescription(Class<?> managedClass, BeanProperty property) {
        return "";
    }

    protected Access getPropertyAccess(Class<?> managedClass, BeanProperty property) {
        if (property.isReadable() && property.isWritable()) {
            return Access.RW;
        }
        if (property.isReadable() && !property.isWritable()) {
            return Access.RO;
        }
        if (!property.isReadable() && property.isWritable()) {
            return Access.WO;
        }
        return Access.NONE;
    }

    protected void populatePropertyDescriptor(Class<?> managedClass, BeanProperty property, Descriptor desc) {
        JmxUtils.populateDeprecation(desc, property.getReadMethod());
        JmxUtils.populateDeprecation(desc, property.getWriteMethod());
        JmxUtils.populateEnable(desc, true);
        JmxUtils.populateDisplayName(desc, StringUtils.capitalize(property.getName()));
        JmxUtils.populateVisibility(desc, 1);
        JmxUtils.populateAccessors(desc, property);
    }

    protected abstract Collection<Method> getMethodOperations(Class<?> var1);

    protected String getOperationExportName(Class<?> managedClass, Method operation) {
        return operation.getName();
    }

    protected String getOperationDescription(Class<?> managedClass, Method operation) {
        return "";
    }

    protected MBeanParameterInfo[] getOperationParameters(Class<?> managedClass, Method operation) {
        Class<?>[] paramTypes = operation.getParameterTypes();
        MBeanParameterInfo[] params = new MBeanParameterInfo[paramTypes.length];
        int i = 0;
        while (i < params.length) {
            params[i] = new MBeanParameterInfo(this.getParameterExportName(managedClass, operation, paramTypes[i], i), paramTypes[i].getName(), this.getParameterDescription(managedClass, operation, paramTypes[i], i));
            ++i;
        }
        return params;
    }

    protected String getParameterExportName(Class<?> managedClass, Method operation, Class<?> paramType, int index) {
        return paramType.getSimpleName();
    }

    protected String getParameterDescription(Class<?> managedClass, Method operation, Class<?> paramType, int index) {
        return "";
    }

    protected void populateOperationDescriptor(Class<?> managedClass, Method operation, Descriptor desc) {
        JmxUtils.populateDeprecation(desc, operation);
        JmxUtils.populateEnable(desc, true);
        JmxUtils.populateDisplayName(desc, operation.getName());
        JmxUtils.populateVisibility(desc, 1);
        JmxUtils.populateRole(desc, Role.OPERATION);
        Collection<BeanProperty> beanProperties = this.getProperties(managedClass);
        for (BeanProperty beanProperty : beanProperties) {
            if (operation.equals(beanProperty.getReadMethod())) {
                JmxUtils.populateRole(desc, Role.GETTER);
                JmxUtils.populateVisibility(desc, 4);
                break;
            }
            if (!operation.equals(beanProperty.getWriteMethod())) continue;
            JmxUtils.populateRole(desc, Role.SETTER);
            JmxUtils.populateVisibility(desc, 4);
            break;
        }
    }
}

