/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.jmx;

import com.mycila.jmx.JmxAttribute;
import com.mycila.jmx.JmxMetadata;
import com.mycila.jmx.JmxOperation;
import com.mycila.jmx.OperationNotFoundException;
import com.mycila.jmx.Signature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.management.AttributeNotFoundException;
import javax.management.ImmutableDescriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;

public final class MBeanMetadata
implements JmxMetadata {
    private final MBeanInfo mBeanInfo;
    private final Map<String, JmxAttribute> attributes = new HashMap<String, JmxAttribute>();
    private final Map<Signature, JmxOperation> operations;

    public MBeanMetadata(String className, String description, Collection<JmxAttribute> attributes, Collection<JmxOperation> operations) {
        ArrayList<MBeanAttributeInfo> attrs = new ArrayList<MBeanAttributeInfo>(attributes.size());
        for (JmxAttribute attribute : attributes) {
            if (this.attributes.put(attribute.getName(), attribute) != null) {
                throw new IllegalArgumentException("Duplicate attribute found: " + attribute.getName());
            }
            attrs.add(attribute.getMetadata());
        }
        ArrayList<MBeanOperationInfo> ops = new ArrayList<MBeanOperationInfo>(attributes.size());
        this.operations = new HashMap<Signature, JmxOperation>();
        for (JmxOperation operation : operations) {
            if (this.operations.put(operation.getSignature(), operation) != null) {
                throw new IllegalArgumentException("Duplicate operation found: " + operation.getSignature());
            }
            ops.add(operation.getMetadata());
        }
        this.mBeanInfo = new MBeanInfo(className, description, attrs.toArray(new MBeanAttributeInfo[attrs.size()]), null, ops.toArray(new MBeanOperationInfo[ops.size()]), null, new ImmutableDescriptor("immutableInfo=true"));
    }

    @Override
    public JmxAttribute getAttribute(String attribute) throws AttributeNotFoundException {
        JmxAttribute att = this.attributes.get(attribute);
        if (att == null) {
            throw new AttributeNotFoundException(attribute);
        }
        return att;
    }

    @Override
    public JmxOperation getOperation(String operation, Class<?> ... paramTypes) throws OperationNotFoundException {
        Signature signature = new Signature(operation, paramTypes);
        JmxOperation op = this.operations.get(signature);
        if (op == null) {
            throw new OperationNotFoundException(signature.toString());
        }
        return op;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.mBeanInfo;
    }
}

