/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.guice.ext.service;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import com.mycila.guice.ext.service.OverrideModule;
import java.util.LinkedList;
import java.util.ServiceLoader;

public class ServiceModule
implements Module {
    private final ClassLoader classLoader;

    public ServiceModule() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ServiceModule(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public void configure(Binder binder) {
        LinkedList<Module> runtime = new LinkedList<Module>();
        LinkedList<Module> overrides = new LinkedList<Module>();
        for (Module module : ServiceLoader.load(Module.class, this.classLoader)) {
            if (module.getClass().isAnnotationPresent(OverrideModule.class)) {
                overrides.add(module);
                continue;
            }
            runtime.add(module);
        }
        if (overrides.isEmpty()) {
            for (Module module : runtime) {
                binder.install(module);
            }
        } else {
            binder.install(Modules.override(runtime).with(overrides));
        }
    }
}

