/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.guice.ext.injection;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.Annotations;
import com.mycila.guice.ext.injection.MethodInvoker;
import com.mycila.guice.ext.injection.MycilaGuiceException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;

public class Reflect {
    private static final Function<Signature, Method> TO_METHOD = new Function<Signature, Method>(){

        @Override
        public Method apply(Signature from) {
            return from.method;
        }
    };
    private static final List<Signature> OBJECT_METHODS = Lists.newArrayList(Iterables.transform(Arrays.asList(Object.class.getDeclaredMethods()), new Function<Method, Signature>(){

        @Override
        public Signature apply(Method from) {
            return new Signature(from);
        }
    }));
    private static final LoadingCache<Class<?>, List<Signature>> METHODS = CacheBuilder.newBuilder().weakKeys().softValues().build(new CacheLoader<Class<?>, List<Signature>>(){

        @Override
        public List<Signature> load(Class<?> clazz) throws Exception {
            Class<?> sc = clazz.getSuperclass();
            List sup = sc == null ? Collections.emptyList() : (sc == Object.class ? OBJECT_METHODS : (List)METHODS.get(sc));
            Method[] methods = clazz.isInterface() ? clazz.getMethods() : clazz.getDeclaredMethods();
            final ArrayList<Signature> thisMethods = new ArrayList<Signature>(methods.length);
            Method[] methodArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (!method.isSynthetic() && !method.isBridge()) {
                    thisMethods.add(new Signature(method));
                }
                ++n2;
            }
            return Lists.newLinkedList(Iterables.concat(thisMethods, Iterables.filter(sup, new Predicate<Signature>(){

                @Override
                public boolean apply(Signature input) {
                    int pos = thisMethods.indexOf(input);
                    if (pos == -1) {
                        return true;
                    }
                    Signature override = (Signature)thisMethods.get(pos);
                    return !Reflect.overrides(override.method, input.method);
                }
            })));
        }
    });

    public static List<Key<?>> getParameterKeys(TypeLiteral<?> type, Method method) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        List<TypeLiteral<?>> parameterTypes = type.getParameterTypes(method);
        ArrayList keys = new ArrayList(parameterTypes.size());
        int i = 0;
        while (i < parameterTypes.size()) {
            keys.add(Reflect.buildKey(parameterTypes.get(i), parameterAnnotations[i]));
            ++i;
        }
        return keys;
    }

    public static Iterable<MethodInvoker> findAllAnnotatedInvokables(Class<?> type, Class<? extends Annotation> annot) {
        return Iterables.transform(Reflect.findAllAnnotatedMethods(type, annot), new Function<Method, MethodInvoker>(){

            @Override
            public MethodInvoker apply(Method method) {
                return MethodInvoker.on(method);
            }
        });
    }

    public static Iterable<Method> findAllAnnotatedMethods(Class<?> type, Class<? extends Annotation> annot) {
        return Iterables.filter(Reflect.findAllMethods(type), Reflect.annotatedBy(annot));
    }

    public static Iterable<Method> findAllMethods(Class<?> type) {
        try {
            return Iterables.transform((Iterable)METHODS.get(type), TO_METHOD);
        }
        catch (ExecutionException e) {
            throw MycilaGuiceException.toRuntime(e);
        }
    }

    public static Iterable<Field> findAllAnnotatedFields(Class<?> type, Class<? extends Annotation> annot) {
        return Iterables.filter(Reflect.findAllFields(type), Reflect.annotatedBy(annot));
    }

    public static Iterable<Field> findAllFields(Class<?> type) {
        return type == null || type == Object.class ? new LinkedList<Field>() : Iterables.concat(Lists.newArrayList(type.getDeclaredFields()), Reflect.findAllFields(type.getSuperclass()));
    }

    public static Class<?> getTargetClass(Class<?> proxy) {
        if (proxy.getName().contains("$$")) {
            while ((proxy = proxy.getSuperclass()).getName().contains("$$")) {
            }
            return proxy;
        }
        return proxy;
    }

    public static Class<?> getTargetClass(Object instance) {
        return Reflect.getTargetClass(instance.getClass());
    }

    public static <T extends AnnotatedElement> Predicate<T> annotatedBy(final Class<? extends Annotation> annotationType) {
        return new Predicate<T>(){

            @Override
            public boolean apply(T element) {
                return element.isAnnotationPresent(annotationType);
            }
        };
    }

    public static Predicate<Method> withSignature(final String methodName, final Class<?> ... classes) {
        return new Predicate<Method>(){

            @Override
            public boolean apply(Method member) {
                if (!member.getName().equals(methodName)) {
                    return false;
                }
                Class<?>[] thisParams = member.getParameterTypes();
                if (thisParams.length != classes.length) {
                    return false;
                }
                int c = 0;
                Class<?>[] classArray = thisParams;
                int n = thisParams.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> thisParam = classArray[n2];
                    if (thisParam != classes[c++]) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        };
    }

    public static boolean overrides(Method a, Method b) {
        int modifiers = b.getModifiers();
        if (Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers)) {
            return true;
        }
        if (Modifier.isPrivate(modifiers)) {
            return false;
        }
        return a.getDeclaringClass().getPackage().equals(b.getDeclaringClass().getPackage());
    }

    private static Key<?> buildKey(TypeLiteral<?> type, Annotation[] annotations) {
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (Annotations.isBindingAnnotation(annotation.annotationType())) {
                return Key.get(type, annotation);
            }
            ++n2;
        }
        return Key.get(type);
    }

    private static final class Signature {
        public final Class[] parameterTypes;
        private final int hash;
        public final Method method;

        public Signature(Method method) {
            this.method = method;
            this.parameterTypes = method.getParameterTypes();
            int h = method.hashCode();
            h = h * 31 + this.parameterTypes.length;
            Class[] classArray = this.parameterTypes;
            int n = this.parameterTypes.length;
            int n2 = 0;
            while (n2 < n) {
                Class parameterType = classArray[n2];
                h = h * 31 + parameterType.hashCode();
                ++n2;
            }
            this.hash = h;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Signature)) {
                return false;
            }
            Signature other = (Signature)o;
            if (!this.method.getName().equals(other.method.getName())) {
                return false;
            }
            if (this.parameterTypes.length != other.parameterTypes.length) {
                return false;
            }
            int i = 0;
            while (i < this.parameterTypes.length) {
                if (this.parameterTypes[i] != other.parameterTypes[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

