/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.generator;

import java.nio.ByteBuffer;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.spdy.api.Settings;
import org.eclipse.jetty.spdy.frames.ControlFrame;
import org.eclipse.jetty.spdy.frames.SettingsFrame;
import org.eclipse.jetty.spdy.generator.ControlFrameGenerator;
import org.eclipse.jetty.util.BufferUtil;

public class SettingsGenerator
extends ControlFrameGenerator {
    public SettingsGenerator(ByteBufferPool bufferPool) {
        super(bufferPool);
    }

    @Override
    public ByteBuffer generate(ControlFrame frame) {
        SettingsFrame settingsFrame = (SettingsFrame)frame;
        Settings settings = settingsFrame.getSettings();
        int size = settings.size();
        int frameBodyLength = 4 + 8 * size;
        int totalLength = 8 + frameBodyLength;
        ByteBuffer buffer = this.getByteBufferPool().acquire(totalLength, true);
        BufferUtil.clearToFill(buffer);
        this.generateControlFrameHeader(settingsFrame, frameBodyLength, buffer);
        buffer.putInt(size);
        for (Settings.Setting setting : settings) {
            int id = setting.id().code();
            byte flags = setting.flag().code();
            int idAndFlags = this.convertIdAndFlags(frame.getVersion(), id, flags);
            buffer.putInt(idAndFlags);
            buffer.putInt(setting.value());
        }
        buffer.flip();
        return buffer;
    }

    private int convertIdAndFlags(short version, int id, byte flags) {
        switch (version) {
            case 2: {
                int idAndFlags = (id << 8) + (flags & 0xFF);
                int result = idAndFlags & 0xFF00FF;
                result += (idAndFlags & 0xFF000000) >>> 16;
                return result += (idAndFlags & 0xFF00) << 16;
            }
            case 3: {
                return (flags << 24) + (id & 0xFFFFFF);
            }
        }
        throw new IllegalStateException();
    }
}

