/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.template.web;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.servlet.ServletConfig;

public final class MarkupOptions {
    public static final String DEBUG = "debug";
    public static final String COMPILER_CACHE = "compilerCache";
    public static final String RESOLVER_CACHE = "resolverCache";
    public static final String DYNAMIC_MARKUPS = "dynamic";
    public static final String GZIP = "gzip";
    public static final String DEFAULT_CHARSET = "defaultCharset";
    public static final String CLIENT_CACHING = "clientCaching";
    public static final String MARKUPS = "markups";
    final ServletConfig config;
    final boolean debug;
    final long clientCaching;
    final boolean compilerCache;
    final boolean resolverCache;
    final boolean dynamic;
    final boolean gzip;
    final String defaultCharset;
    final File webappDir;
    final Collection<String> markups;

    private MarkupOptions(ServletConfig config) {
        this.config = config;
        this.debug = this.getBool(DEBUG, false);
        this.compilerCache = this.getBool(COMPILER_CACHE, true);
        this.resolverCache = this.getBool(RESOLVER_CACHE, true);
        this.dynamic = this.getBool(DYNAMIC_MARKUPS, true);
        this.gzip = this.getBool(GZIP, true);
        this.defaultCharset = this.get(DEFAULT_CHARSET, "UTF-8");
        this.clientCaching = this.getLong(CLIENT_CACHING, 2592000L);
        this.webappDir = new File(config.getServletContext().getRealPath(""));
        String[] exts = this.get(MARKUPS, "html").split(",|;|\\s|-|\\|");
        HashSet<String> set = new HashSet<String>();
        for (String ext : exts) {
            if (ext == null || ext.length() <= 0) continue;
            set.add(ext);
        }
        this.markups = Collections.unmodifiableSet(set);
    }

    private boolean getBool(String opt, boolean def) {
        return Boolean.parseBoolean(this.get(opt, String.valueOf(def)));
    }

    private long getLong(String opt, long def) {
        return Long.parseLong(this.get(opt, String.valueOf(def)));
    }

    private String get(String opt, String def) {
        String val = this.config.getInitParameter(opt);
        if (val == null) {
            val = System.getProperty("ovea.markup." + opt);
        }
        return val == null ? def : val;
    }

    private String opt(String opt) {
        return this.get(opt, null);
    }

    static MarkupOptions from(ServletConfig config) {
        return new MarkupOptions(config);
    }
}

