/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.template.web;

import com.ovea.tajin.framework.io.Gzip;
import org.apache.shiro.crypto.hash.Md5Hash;

final class MarkupData {
    final byte[] data;
    final byte[] gzip;
    final String tag;
    final long when;
    final RuntimeException error;

    MarkupData(byte[] data) {
        long time = System.currentTimeMillis();
        this.when = time - time % 1000L;
        this.data = data;
        this.gzip = Gzip.compress(data);
        this.error = null;
        this.tag = "\"" + new Md5Hash(data).toBase64() + "\"";
    }

    MarkupData(RuntimeException error) {
        long time = System.currentTimeMillis();
        this.when = time - time % 1000L;
        this.error = error;
        this.data = null;
        this.gzip = null;
        this.tag = null;
    }

    boolean hasError() {
        return this.error != null;
    }

    RuntimeException error() {
        return this.error;
    }

    void reThrow() throws RuntimeException {
        throw this.error;
    }
}

