/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.template;

import com.ovea.tajin.framework.io.Resource;
import com.ovea.tajin.framework.template.TemplateCompiler;
import com.ovea.tajin.framework.template.TemplateResolverException;
import com.ovea.tajin.framework.template.TemplateResolverSkeleton;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;

public final class FileSystemTemplateResolver
extends TemplateResolverSkeleton {
    private final File webDir;

    public FileSystemTemplateResolver(TemplateCompiler compiler, File baseDir) {
        super(compiler);
        try {
            this.webDir = baseDir.getCanonicalFile();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    protected Resource tryPath(String path) {
        File file = new File(this.webDir, path);
        if (file.exists()) {
            try {
                if (!file.getCanonicalFile().getAbsolutePath().startsWith(this.webDir.getAbsolutePath())) {
                    throw new TemplateResolverException("Web template folder " + this.webDir + " cannot serve template " + path);
                }
                return Resource.url(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new TemplateResolverException("Error getting URL from file " + file + " : " + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new TemplateResolverException("Error accessing file path " + file + " : " + e.getMessage(), e);
            }
        }
        return null;
    }
}

