/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.support.guice;

import com.google.inject.Binder;
import com.google.inject.BindingAnnotation;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.ovea.tajin.framework.support.guice.AnnotatedMemberHandler;
import com.ovea.tajin.framework.support.guice.AnnotatedMemberHandlerTypeListener;
import com.ovea.tajin.framework.support.guice.FieldHandler;
import com.ovea.tajin.framework.support.guice.FieldHandlerTypeListener;
import com.ovea.tajin.framework.support.guice.KeyProvider;
import com.ovea.tajin.framework.support.guice.MemberInjectorTypeListener;
import com.ovea.tajin.framework.support.guice.MethodHandler;
import com.ovea.tajin.framework.support.guice.MethodHandlerTypeListener;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.inject.Qualifier;
import net.sf.cglib.core.Signature;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.objectweb.asm.Type;

public final class TajinGuice {
    private final Binder binder;

    private TajinGuice(Binder binder) {
        this.binder = binder;
    }

    public TajinGuice bindInterceptor(Class<?> interf, String methodName, Class<?>[] params, MethodInterceptor ... interceptors) {
        try {
            return this.bindInterceptor(Matchers.subclassesOf(interf), new SignatureMatcher(interf.getMethod(methodName, params)), interceptors);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public TajinGuice bindInterceptor(Matcher<? super Class<?>> classMatcher, Matcher<? super Method> methodMatcher, MethodInterceptor ... interceptors) {
        for (MethodInterceptor interceptor : interceptors) {
            this.requestInjection(interceptor);
        }
        this.binder.bindInterceptor(classMatcher, methodMatcher, interceptors);
        return this;
    }

    public <A extends Annotation> TajinGuice bindAnnotationInjector(Class<A> annotationType, Class<? extends KeyProvider<A>> providerClass) {
        this.binder.bindListener(Matchers.any(), this.requestInjection(new MemberInjectorTypeListener<A>(annotationType, providerClass)));
        return this;
    }

    public <A extends Annotation> TajinGuice handleMethodAfterInjection(Class<A> annotationType, Class<? extends MethodHandler<A>> providerClass) {
        this.binder.bindListener(Matchers.any(), this.requestInjection(new MethodHandlerTypeListener<A>(annotationType, providerClass)));
        return this;
    }

    public <A extends Annotation> TajinGuice handleFieldAfterInjection(Class<A> annotationType, Class<? extends FieldHandler<A>> providerClass) {
        this.binder.bindListener(Matchers.any(), this.requestInjection(new FieldHandlerTypeListener<A>(annotationType, providerClass)));
        return this;
    }

    public <A extends Annotation> TajinGuice handleAfterInjection(Class<A> annotationType, Class<? extends AnnotatedMemberHandler<A>> providerClass) {
        this.binder.bindListener(Matchers.any(), this.requestInjection(new AnnotatedMemberHandlerTypeListener<A>(annotationType, providerClass)));
        return this;
    }

    public <T> TajinGuice bind(Class<T> type, T instance) {
        this.binder.bind(type).toInstance(this.requestInjection(instance));
        return this;
    }

    public TajinGuice install(Module module) {
        this.binder.install(this.requestInjection(module));
        return this;
    }

    public <T> T requestInjection(T object) {
        this.binder.requestInjection(object);
        return object;
    }

    public MethodInterceptor createDelegatingInterceptor(Class<? extends MethodInterceptor> type) {
        return this.createDelegatingInterceptor(Key.get(type));
    }

    public MethodInterceptor createDelegatingInterceptor(Key<? extends MethodInterceptor> type) {
        Provider<? extends MethodInterceptor> provider = this.binder.getProvider(type);
        return new DelegatingInterceptor(provider);
    }

    public static TajinGuice in(Binder binder) {
        return new TajinGuice(binder);
    }

    public static boolean isBindingAnnotation(Class<? extends Annotation> annotationType) {
        return annotationType.isAnnotationPresent(BindingAnnotation.class) || annotationType.isAnnotationPresent(Qualifier.class);
    }

    static final class SignatureMatcher
    extends AbstractMatcher<Method> {
        private final Signature signature;

        private SignatureMatcher(Method method) {
            this.signature = new Signature(method.getName(), Type.getReturnType(method), Type.getArgumentTypes(method));
        }

        @Override
        public boolean matches(Method method) {
            return this.signature.equals(new Signature(method.getName(), Type.getReturnType(method), Type.getArgumentTypes(method)));
        }
    }

    private static final class DelegatingInterceptor
    implements MethodInterceptor {
        private final Provider<? extends MethodInterceptor> provider;

        private DelegatingInterceptor(Provider<? extends MethodInterceptor> provider) {
            this.provider = provider;
        }

        @Override
        public Object invoke(MethodInvocation invocation) throws Throwable {
            return this.provider.get().invoke(invocation);
        }

        public String toString() {
            return this.provider.get().toString();
        }
    }
}

