/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.support.guice;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.internal.BytecodeGen;
import com.google.inject.internal.cglib.reflect.$FastMethod;
import com.ovea.tajin.framework.support.guice.MethodInvoker;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.ExecutionException;
import net.sf.cglib.core.CodeGenerationException;

class Proxy {
    private static final LoadingCache<Method, MethodInvoker> INVOKER_CACHE = CacheBuilder.newBuilder().weakKeys().weakValues().build(new CacheLoader<Method, MethodInvoker>(){

        @Override
        public MethodInvoker load(final Method method) throws Exception {
            int modifiers = method.getModifiers();
            if (!Modifier.isPrivate(modifiers) && !Modifier.isProtected(modifiers)) {
                try {
                    final $FastMethod fastMethod = BytecodeGen.newFastClass(method.getDeclaringClass(), BytecodeGen.Visibility.forMember(method)).getMethod(method);
                    return new MethodInvoker(){

                        @Override
                        public Object invoke(Object target, Object ... parameters) throws IllegalAccessException, InvocationTargetException {
                            return fastMethod.invoke(target, parameters);
                        }
                    };
                }
                catch (CodeGenerationException codeGenerationException) {
                    // empty catch block
                }
            }
            if (!Modifier.isPublic(modifiers) || !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
                method.setAccessible(true);
            }
            return new MethodInvoker(){

                @Override
                public Object invoke(Object target, Object ... parameters) throws IllegalAccessException, InvocationTargetException {
                    return method.invoke(target, parameters);
                }
            };
        }
    });

    private Proxy() {
    }

    public static MethodInvoker invoker(Method method) {
        try {
            return INVOKER_CACHE.get(method);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

