/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.support.guice;

import com.google.common.collect.Iterables;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import com.ovea.tajin.framework.support.guice.AnnotatedMember;
import com.ovea.tajin.framework.support.guice.AnnotatedMemberHandler;
import com.ovea.tajin.framework.util.Reflect;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

final class AnnotatedMemberHandlerTypeListener<A extends Annotation>
implements TypeListener {
    private final Class<A> annotationType;
    private final Class<? extends AnnotatedMemberHandler<A>> handlerClass;

    public AnnotatedMemberHandlerTypeListener(Class<A> annotationType, Class<? extends AnnotatedMemberHandler<A>> handlerClass) {
        this.annotationType = annotationType;
        this.handlerClass = handlerClass;
    }

    @Override
    public <I> void hear(final TypeLiteral<I> type, TypeEncounter<I> encounter) {
        final Provider<? extends AnnotatedMemberHandler<A>> provider = encounter.getProvider(this.handlerClass);
        encounter.register(new InjectionListener<I>(){

            @Override
            public void afterInjection(I injectee) {
                AnnotatedMemberHandler handler = (AnnotatedMemberHandler)provider.get();
                for (Field field : Reflect.findFields(type.getRawType(), Reflect.annotatedBy(AnnotatedMemberHandlerTypeListener.this.annotationType))) {
                    handler.handle(type, injectee, new AnnotatedMember<Field>(field), field.getAnnotation(AnnotatedMemberHandlerTypeListener.this.annotationType));
                }
                for (Method method : Iterables.filter(Reflect.findMethods(type.getRawType()), Reflect.annotatedBy(AnnotatedMemberHandlerTypeListener.this.annotationType))) {
                    handler.handle(type, injectee, new AnnotatedMember<Method>(method), method.getAnnotation(AnnotatedMemberHandlerTypeListener.this.annotationType));
                }
            }
        });
    }
}

