/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.jmx;

import com.ovea.tajin.framework.jmx.JmxServerException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;

public class JmxServerFactory {
    public MBeanServer locateDefault() throws JmxServerException {
        return this.locateByAgent(null);
    }

    public MBeanServer locateByAgent(String agent) throws JmxServerException {
        ArrayList<MBeanServer> servers;
        if (!"".equals(agent) && (servers = MBeanServerFactory.findMBeanServer(agent)) != null && !servers.isEmpty()) {
            return (MBeanServer)servers.get(0);
        }
        if (agent == null || agent.length() == 0) {
            try {
                return ManagementFactory.getPlatformMBeanServer();
            }
            catch (SecurityException ex) {
                throw new JmxServerException("No specific MBeanServer found, and not allowed to obtain the Java platform MBeanServer", ex);
            }
        }
        throw new JmxServerException("Unable to locate an MBeanServer instance" + (agent != null ? " with agent id [" + agent + "]" : ""));
    }

    public MBeanServer locateByDomain(String domain) throws JmxServerException {
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        if (servers != null && !servers.isEmpty()) {
            for (MBeanServer server : servers) {
                if (!domain.equalsIgnoreCase(server.getDefaultDomain())) continue;
                return server;
            }
        }
        throw new JmxServerException("Unable to locate an MBeanServer instance" + (domain != null ? " with domain [" + domain + "]" : ""));
    }
}

