/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.jmx;

import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import com.ovea.tajin.framework.jmx.ExportBehavior;
import com.ovea.tajin.framework.jmx.JmxExporter;
import com.ovea.tajin.framework.jmx.MycilaJmxExporter;
import com.ovea.tajin.framework.jmx.annotation.JmxBean;
import com.ovea.tajin.framework.support.guice.ClassToTypeLiteralMatcherAdapter;
import java.lang.management.ManagementFactory;
import javax.inject.Singleton;
import javax.management.MBeanServer;

public class JmxModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.bindListener(ClassToTypeLiteralMatcherAdapter.adapt(Matchers.annotatedWith(JmxBean.class)), new TypeListener(){

            @Override
            public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
                final Provider<JmxExporter> exporter = encounter.getProvider(JmxExporter.class);
                encounter.register(new InjectionListener<I>(){

                    @Override
                    public void afterInjection(I injectee) {
                        ((JmxExporter)exporter.get()).register(injectee);
                    }
                });
            }
        });
    }

    @Provides
    @Singleton
    JmxExporter jmxExporter(MBeanServer server) {
        MycilaJmxExporter exporter = new MycilaJmxExporter(server);
        exporter.setExportBehavior(ExportBehavior.FAIL_ON_EXISTING);
        exporter.setEnsureUnique(false);
        return exporter;
    }

    @Provides
    @Singleton
    MBeanServer mBeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }
}

