/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.jmx;

import com.ovea.tajin.framework.jmx.BeanProperty;
import com.ovea.tajin.framework.jmx.ReflectionMetadataAssemblerSkeleton;
import com.ovea.tajin.framework.jmx.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;

public final class CustomMetadataAssembler
extends ReflectionMetadataAssemblerSkeleton {
    private final Collection<Field> fields = new HashSet<Field>();
    private final Collection<Method> methods = new HashSet<Method>();
    private final Collection<BeanProperty> properties = new HashSet<BeanProperty>();

    @Override
    public boolean canInclude(Class<?> managedClass, Field field) {
        return this.fields.contains(field);
    }

    @Override
    public boolean canInclude(Class<?> managedClass, Method method) {
        for (BeanProperty property : this.properties) {
            if (!method.equals(property.getReadMethod()) && !method.equals(property.getWriteMethod())) continue;
            return true;
        }
        return this.methods.contains(method);
    }

    @Override
    public boolean canInclude(Class<?> managedClass, BeanProperty<?> property) {
        return this.properties.contains(property);
    }

    public CustomMetadataAssembler addAttribute(Class<?> clazz, String name) {
        Field field = ReflectionUtils.findField(clazz, name);
        if (field == null) {
            throw new IllegalArgumentException("Attribute '" + name + "' not found in class hierarchy " + clazz.getName());
        }
        return this.addAttribute(field);
    }

    public CustomMetadataAssembler addAttribute(Class<?> clazz, String name, Class<?> type) {
        Field field = ReflectionUtils.findField(clazz, name, type);
        if (field == null) {
            throw new IllegalArgumentException("Attribute '" + name + "' of type " + type + " not found in class hierarchy " + clazz.getName());
        }
        return this.addAttribute(field);
    }

    public CustomMetadataAssembler addAttribute(Field field) {
        if (field == null) {
            throw new NullPointerException("Field cannot be null");
        }
        this.fields.add(field);
        return this;
    }

    public CustomMetadataAssembler addProperty(Class<?> clazz, String name) {
        BeanProperty<?> property = BeanProperty.findProperty(clazz, name);
        if (property == null) {
            throw new IllegalArgumentException("Property '" + name + "' not found in class hierarchy " + clazz.getName());
        }
        return this.addProperty(property);
    }

    public CustomMetadataAssembler addProperty(Class<?> clazz, String name, Class<?> type) {
        BeanProperty<?> property = BeanProperty.findProperty(clazz, name, type);
        if (property == null) {
            throw new IllegalArgumentException("Property '" + name + "' of type " + type + " not found in class hierarchy " + clazz.getName());
        }
        return this.addProperty(property);
    }

    public CustomMetadataAssembler addProperty(BeanProperty<?> property) {
        if (property == null) {
            throw new NullPointerException("Property cannot be null");
        }
        this.properties.add(property);
        return this;
    }

    public CustomMetadataAssembler addOperation(Class<?> clazz, String name) {
        Method method = ReflectionUtils.findMethod(clazz, name, null);
        if (method == null) {
            throw new IllegalArgumentException("Operation '" + name + "' not found in class hierarchy " + clazz.getName());
        }
        return this.addOperation(method);
    }

    public CustomMetadataAssembler addOperation(Class<?> clazz, String name, Class<?> returnType, Class<?> ... parameterTypes) {
        Method method = ReflectionUtils.findMethod(clazz, name, returnType, parameterTypes);
        if (method == null) {
            throw new IllegalArgumentException("Operation '" + name + "' returning " + returnType + " not found in class hierarchy " + clazz.getName());
        }
        return this.addOperation(method);
    }

    public CustomMetadataAssembler addOperation(Class<?> clazz, String name, Class<?> returnType) {
        Method method = ReflectionUtils.findMethod(clazz, name, returnType);
        if (method == null) {
            throw new IllegalArgumentException("Operation '" + name + "' returning " + returnType + " not found in class hierarchy " + clazz.getName());
        }
        return this.addOperation(method);
    }

    public CustomMetadataAssembler addOperation(Method method) {
        if (method == null) {
            throw new NullPointerException("Method cannot be null");
        }
        this.methods.add(method);
        return this;
    }
}

