/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.jmx;

import com.ovea.tajin.framework.jmx.AnnotationMetadataAssembler;
import com.ovea.tajin.framework.jmx.ExceptionUtils;
import com.ovea.tajin.framework.jmx.JmxMetadataAssembler;
import com.ovea.tajin.framework.jmx.PublicMetadataAssembler;
import com.ovea.tajin.framework.jmx.annotation.JmxBean;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;

public final class Assemblers {
    private static final Map<Class<? extends JmxMetadataAssembler>, Reference<JmxMetadataAssembler>> cache = new WeakHashMap<Class<? extends JmxMetadataAssembler>, Reference<JmxMetadataAssembler>>();

    private Assemblers() {
    }

    public static JmxMetadataAssembler get(Class<?> mbeanClass) {
        JmxBean jmxBean = mbeanClass.getAnnotation(JmxBean.class);
        return jmxBean == null ? Assemblers.load(PublicMetadataAssembler.class) : Assemblers.load(jmxBean.assembler());
    }

    private static JmxMetadataAssembler load(Class<? extends JmxMetadataAssembler> exp) {
        JmxMetadataAssembler exposure;
        Reference<JmxMetadataAssembler> ref;
        if (exp == null) {
            exp = AnnotationMetadataAssembler.class;
        }
        if ((ref = cache.get(exp)) != null && (exposure = ref.get()) != null) {
            return exposure;
        }
        try {
            exposure = exp.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            throw ExceptionUtils.rethrow(e);
        }
        cache.put(exp, new WeakReference<JmxMetadataAssembler>(exposure));
        return exposure;
    }
}

