/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.servlet.FiltersModuleBuilder;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.InternalServletModule;
import com.google.inject.servlet.ServletsModuleBuilder;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;

public class ServletModule
extends AbstractModule {
    private FiltersModuleBuilder filtersModuleBuilder;
    private ServletsModuleBuilder servletsModuleBuilder;

    @Override
    protected final void configure() {
        Preconditions.checkState(this.filtersModuleBuilder == null, "Re-entry is not allowed.");
        Preconditions.checkState(this.servletsModuleBuilder == null, "Re-entry is not allowed.");
        this.filtersModuleBuilder = new FiltersModuleBuilder();
        this.servletsModuleBuilder = new ServletsModuleBuilder();
        try {
            this.install(new InternalServletModule());
            this.configureServlets();
            this.install(this.filtersModuleBuilder);
            this.install(this.servletsModuleBuilder);
        }
        finally {
            this.filtersModuleBuilder = null;
            this.servletsModuleBuilder = null;
        }
    }

    protected void configureServlets() {
    }

    protected final FilterKeyBindingBuilder filter(String urlPattern, String ... morePatterns) {
        return this.filtersModuleBuilder.filter(Lists.asList(urlPattern, morePatterns));
    }

    protected final FilterKeyBindingBuilder filterRegex(String regex, String ... regexes) {
        return this.filtersModuleBuilder.filterRegex(Lists.asList(regex, regexes));
    }

    protected final ServletKeyBindingBuilder serve(String urlPattern, String ... morePatterns) {
        return this.servletsModuleBuilder.serve(Lists.asList(urlPattern, morePatterns));
    }

    protected final ServletKeyBindingBuilder serveRegex(String regex, String ... regexes) {
        return this.servletsModuleBuilder.serveRegex(Lists.asList(regex, regexes));
    }

    protected final ServletContext getServletContext() {
        return GuiceFilter.getServletContext();
    }

    public static interface FilterKeyBindingBuilder {
        public void through(Class<? extends Filter> var1);

        public void through(Key<? extends Filter> var1);

        public void through(Filter var1);

        public void through(Class<? extends Filter> var1, Map<String, String> var2);

        public void through(Key<? extends Filter> var1, Map<String, String> var2);

        public void through(Filter var1, Map<String, String> var2);
    }

    public static interface ServletKeyBindingBuilder {
        public void with(Class<? extends HttpServlet> var1);

        public void with(Key<? extends HttpServlet> var1);

        public void with(HttpServlet var1);

        public void with(Class<? extends HttpServlet> var1, Map<String, String> var2);

        public void with(Key<? extends HttpServlet> var1, Map<String, String> var2);

        public void with(HttpServlet var1, Map<String, String> var2);
    }
}

