/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.jmx;

import com.mycila.jmx.AnnotationMetadataAssembler;
import com.mycila.jmx.ExceptionUtils;
import com.mycila.jmx.JmxMetadataAssembler;
import com.mycila.jmx.PublicMetadataAssembler;
import com.mycila.jmx.annotation.JmxBean;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;

public final class Assemblers {
    private static final Map<Class<? extends JmxMetadataAssembler>, Reference<JmxMetadataAssembler>> cache = new WeakHashMap<Class<? extends JmxMetadataAssembler>, Reference<JmxMetadataAssembler>>();

    private Assemblers() {
    }

    public static JmxMetadataAssembler get(Class<?> mbeanClass) {
        JmxBean jmxBean = mbeanClass.getAnnotation(JmxBean.class);
        return jmxBean == null ? Assemblers.load(PublicMetadataAssembler.class) : Assemblers.load(jmxBean.assembler());
    }

    private static JmxMetadataAssembler load(Class<? extends JmxMetadataAssembler> exp) {
        JmxMetadataAssembler exposure;
        Reference<JmxMetadataAssembler> ref;
        if (exp == null) {
            exp = AnnotationMetadataAssembler.class;
        }
        if ((ref = cache.get(exp)) != null && (exposure = ref.get()) != null) {
            return exposure;
        }
        try {
            exposure = exp.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            throw ExceptionUtils.rethrow(e);
        }
        cache.put(exp, new WeakReference<JmxMetadataAssembler>(exposure));
        return exposure;
    }
}

