/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.jmx;

import java.lang.reflect.Proxy;

final class AopUtils {
    private AopUtils() {
    }

    public static Class<?> getTargetClass(Object candidate) {
        SupportedProxy[] supportedProxyArray = SupportedProxy.values();
        int n = supportedProxyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c;
            SupportedProxy supportedProxy = supportedProxyArray[n2];
            if (supportedProxy.isProxy(candidate) && (c = supportedProxy.getTargetType(candidate)) != null) {
                return c;
            }
            ++n2;
        }
        return candidate.getClass();
    }

    private static enum SupportedProxy {
        SPRING{

            @Override
            Class<?> getTargetType(Object proxy) {
                try {
                    Class<?>[] classArray = proxy.getClass().getInterfaces();
                    int n = classArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Class<?> itf = classArray[n2];
                        if ("org.springframework.aop.TargetClassAware".equals(itf.getName())) {
                            return (Class)proxy.getClass().getMethod("getTargetClass", new Class[0]).invoke(proxy, new Object[0]);
                        }
                        ++n2;
                    }
                }
                catch (Exception exception) {}
                return null;
            }

            @Override
            boolean isProxyClass(Class<?> c) {
                Class<?>[] classArray = c.getInterfaces();
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> itf = classArray[n2];
                    if ("org.springframework.aop.SpringProxy".equals(itf.getName()) || "org.springframework.aop.TargetClassAware".equals(itf.getName())) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        }
        ,
        CGLIB{

            @Override
            Class<?> getTargetType(Object proxy) {
                return proxy.getClass().getSuperclass();
            }

            @Override
            boolean isProxyClass(Class<?> c) {
                if (c.getName().contains("$$")) {
                    return true;
                }
                Class<?>[] classArray = c.getInterfaces();
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> itf = classArray[n2];
                    if ("net.sf.cglib.proxy.Factory".equals(itf.getName())) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        }
        ,
        JDK{

            @Override
            Class<?> getTargetType(Object proxy) {
                return null;
            }

            @Override
            boolean isProxyClass(Class<?> c) {
                return Proxy.isProxyClass(c);
            }
        };


        boolean isProxy(Object o) {
            return this.isProxyClass(o.getClass());
        }

        abstract boolean isProxyClass(Class<?> var1);

        abstract Class<?> getTargetType(Object var1);
    }
}

