/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.guice.ext.closeable;

import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.MembersInjector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeConverterBinding;
import com.mycila.guice.ext.closeable.CloseableInjector;
import com.mycila.guice.ext.closeable.InjectorCloseListener;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class MycilaCloseableInjector
implements CloseableInjector {
    private volatile boolean closed;
    @Inject
    private volatile Injector injector;

    MycilaCloseableInjector() {
    }

    @Override
    public synchronized void close() {
        if (!this.closed && this.injector != null) {
            this.closed = true;
            Injector current = this.injector;
            this.injector = null;
            for (Binding<?> binding : current.getAllBindings().values()) {
                Object o;
                if (!Scopes.isSingleton(binding) || !((o = binding.getProvider().get()) instanceof InjectorCloseListener)) continue;
                ((InjectorCloseListener)o).onInjectorClosing();
            }
        }
    }

    private Injector injector() {
        if (this.closed || this.injector == null) {
            throw new IllegalStateException("Injector closed !");
        }
        return this.injector;
    }

    @Override
    public void injectMembers(Object instance) {
        this.injector().injectMembers(instance);
    }

    @Override
    public <T> MembersInjector<T> getMembersInjector(TypeLiteral<T> typeLiteral) {
        return this.injector().getMembersInjector(typeLiteral);
    }

    @Override
    public <T> MembersInjector<T> getMembersInjector(Class<T> type) {
        return this.injector().getMembersInjector(type);
    }

    @Override
    public Map<Key<?>, Binding<?>> getBindings() {
        return this.injector().getBindings();
    }

    @Override
    public Map<Key<?>, Binding<?>> getAllBindings() {
        return this.injector().getAllBindings();
    }

    @Override
    public <T> Binding<T> getBinding(Key<T> key) {
        return this.injector().getBinding(key);
    }

    @Override
    public <T> Binding<T> getBinding(Class<T> type) {
        return this.injector().getBinding(type);
    }

    @Override
    public <T> Binding<T> getExistingBinding(Key<T> key) {
        return this.injector().getExistingBinding(key);
    }

    @Override
    public <T> List<Binding<T>> findBindingsByType(TypeLiteral<T> type) {
        return this.injector().findBindingsByType(type);
    }

    @Override
    public <T> Provider<T> getProvider(Key<T> key) {
        return this.injector().getProvider(key);
    }

    @Override
    public <T> Provider<T> getProvider(Class<T> type) {
        return this.injector().getProvider(type);
    }

    @Override
    public <T> T getInstance(Key<T> key) {
        return this.injector().getInstance(key);
    }

    @Override
    public <T> T getInstance(Class<T> type) {
        return this.injector().getInstance(type);
    }

    @Override
    public Injector getParent() {
        return this.injector().getParent();
    }

    @Override
    public Injector createChildInjector(Iterable<? extends Module> modules) {
        return this.injector().createChildInjector(modules);
    }

    @Override
    public Injector createChildInjector(Module ... modules) {
        return this.injector().createChildInjector(modules);
    }

    @Override
    public Map<Class<? extends Annotation>, Scope> getScopeBindings() {
        return this.injector().getScopeBindings();
    }

    @Override
    public Set<TypeConverterBinding> getTypeConverterBindings() {
        return this.injector().getTypeConverterBindings();
    }
}

