/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.jmx;

import com.mycila.jmx.ClassUtils;
import com.mycila.jmx.ReflectionUtils;
import com.mycila.jmx.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class BeanProperty
implements AnnotatedElement {
    private Method readMethod;
    private Method writeMethod;
    private final Class<?> type;
    private final String name;

    private BeanProperty(String name, Method readMethod, Method writeMethod) {
        if (readMethod == null && writeMethod == null) {
            throw new IllegalArgumentException("Invalid property " + name + ": missing at least one accessor method");
        }
        if (readMethod != null && writeMethod != null && !readMethod.getReturnType().equals(writeMethod.getParameterTypes()[0])) {
            throw new IllegalArgumentException("return type differs: " + readMethod.getReturnType() + " and " + writeMethod.getParameterTypes()[0]);
        }
        this.name = name;
        this.type = readMethod != null ? readMethod.getReturnType() : writeMethod.getParameterTypes()[0];
        this.readMethod = readMethod;
        this.writeMethod = writeMethod;
    }

    public Method getReadMethod() {
        return this.readMethod;
    }

    public Method getWriteMethod() {
        return this.writeMethod;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public boolean isReadable() {
        return this.readMethod != null;
    }

    public boolean isWritable() {
        return this.writeMethod != null;
    }

    public void clearReadable() {
        this.readMethod = null;
    }

    public void clearWritable() {
        this.writeMethod = null;
    }

    public Object get(Object o) throws Throwable {
        if (!this.isReadable()) {
            throw new IllegalStateException("Property not readable: " + this);
        }
        if (!this.getReadMethod().isAccessible()) {
            this.getReadMethod().setAccessible(true);
        }
        try {
            Object res = this.getReadMethod().invoke(o, new Object[0]);
            if (!ClassUtils.isAssignableValue(this.getType(), res)) {
                throw new IllegalArgumentException("Invalid property: got type " + res.getClass().getName() + " but expect " + this.getType().getName());
            }
            return res;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public void set(Object o, Object value) throws Throwable {
        if (!this.isWritable()) {
            throw new IllegalStateException("Property not writable: " + this);
        }
        if (!this.getWriteMethod().isAccessible()) {
            this.getWriteMethod().setAccessible(true);
        }
        try {
            this.getWriteMethod().invoke(o, value);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        A annot = null;
        if (this.isReadable()) {
            annot = this.getReadMethod().getAnnotation(annotationClass);
        }
        if (annot == null && this.isWritable()) {
            annot = this.getWriteMethod().getAnnotation(annotationClass);
        }
        return annot;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.isReadable() && this.getReadMethod().isAnnotationPresent(annotationClass) || this.isWritable() && this.getWriteMethod().isAnnotationPresent(annotationClass);
    }

    @Override
    public Annotation[] getAnnotations() {
        Annotation[] annots = new Annotation[]{};
        if (this.isReadable()) {
            annots = this.getReadMethod().getAnnotations();
        }
        if (annots.length == 0 && this.isWritable()) {
            annots = this.getWriteMethod().getAnnotations();
        }
        return annots;
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        Annotation[] annots = new Annotation[]{};
        if (this.isReadable()) {
            annots = this.getReadMethod().getDeclaredAnnotations();
        }
        if (annots.length == 0 && this.isWritable()) {
            annots = this.getWriteMethod().getDeclaredAnnotations();
        }
        return annots;
    }

    public String toString() {
        return String.valueOf(ClassUtils.getQualifiedName(this.getType())) + " " + this.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeanProperty that = (BeanProperty)o;
        return this.getName().equals(that.getName()) && this.getType().equals(that.getType());
    }

    public int hashCode() {
        int result = this.getType().hashCode();
        result = 31 * result + this.getName().hashCode();
        return result;
    }

    public static BeanProperty findProperty(Class<?> clazz, Method method) {
        if (ReflectionUtils.isIsMethod(method)) {
            return BeanProperty.findProperty(clazz, StringUtils.uncapitalize(method.getName().substring(2)), method.getReturnType());
        }
        if (ReflectionUtils.isGetMethod(method)) {
            return BeanProperty.findProperty(clazz, StringUtils.uncapitalize(method.getName().substring(3)), method.getReturnType());
        }
        if (ReflectionUtils.isSetter(method)) {
            return BeanProperty.findProperty(clazz, StringUtils.uncapitalize(method.getName().substring(3)), method.getParameterTypes()[0]);
        }
        return null;
    }

    public static BeanProperty findProperty(Class<?> clazz, String property) {
        return BeanProperty.findProperty(clazz, property, null);
    }

    public static BeanProperty findProperty(Class<?> clazz, String property, Class<?> type) {
        Method getter;
        String name = StringUtils.capitalize(property);
        Method is = ReflectionUtils.findMethod(clazz, "is" + name, type, new Class[0]);
        Method get = ReflectionUtils.findMethod(clazz, "get" + name, type, new Class[0]);
        Method setter = ReflectionUtils.findMethod(clazz, "set" + name, Void.TYPE, type);
        Method method = getter = get != null ? get : is;
        if (setter == null && getter == null || setter != null && getter != null && !setter.getParameterTypes()[0].equals(getter.getReturnType())) {
            return null;
        }
        return new BeanProperty(property, getter, setter);
    }
}

