/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.template.web;

import com.ovea.tajin.framework.template.ResolvedTemplate;
import com.ovea.tajin.framework.template.TemplateResolver;
import com.ovea.tajin.framework.template.web.ContextProvider;
import com.ovea.tajin.framework.template.web.LocaleProvider;
import com.ovea.tajin.framework.template.web.MarkupData;
import com.ovea.tajin.framework.template.web.MarkupDataBuilder;
import com.ovea.tajin.framework.template.web.MarkupOptions;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

final class DynamicMarkupDataBuilder
implements MarkupDataBuilder {
    private final TemplateResolver resolver;
    private final LocaleProvider localeProvider;
    private final ContextProvider contextProvider;
    private final MarkupOptions markupOptions;

    DynamicMarkupDataBuilder(ContextProvider contextProvider, LocaleProvider localeProvider, MarkupOptions markupOptions, TemplateResolver resolver) {
        this.contextProvider = contextProvider;
        this.localeProvider = localeProvider;
        this.markupOptions = markupOptions;
        this.resolver = resolver;
    }

    @Override
    public MarkupData build(HttpServletRequest request, HttpServletResponse response, String path) {
        try {
            ResolvedTemplate template = this.resolver.resolve(path, this.localeProvider.get(request));
            String markup = template.merge(this.contextProvider.build(request, response));
            return new MarkupData(markup.getBytes(this.markupOptions.defaultCharset));
        }
        catch (RuntimeException e) {
            return new MarkupData(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

