/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.i18n;

import com.ovea.tajin.framework.i18n.I18NService;
import com.ovea.tajin.framework.i18n.I18NServiceFactory;
import com.ovea.tajin.framework.i18n.JsonI18NService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class JsonI18NServiceFactory
implements I18NServiceFactory {
    private final ConcurrentMap<String, JsonI18NService> cache = new ConcurrentHashMap<String, JsonI18NService>();
    private boolean debug;
    private I18NService.MissingKeyBehaviour missingKeyBehaviour = I18NService.MissingKeyBehaviour.THROW_EXCEPTION;

    @Override
    public I18NService forBundle(String bundleName) {
        JsonI18NService service = (JsonI18NService)this.cache.get(bundleName = bundleName.startsWith("/") ? bundleName.substring(1) : bundleName);
        if (service == null) {
            this.cache.putIfAbsent(bundleName, new JsonI18NService(bundleName));
            service = (JsonI18NService)this.cache.get(bundleName);
            service.setDebug(this.isDebug());
            service.setMissingKeyBehaviour(this.getMissingKeyBehaviour());
        }
        return service;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public I18NService.MissingKeyBehaviour getMissingKeyBehaviour() {
        return this.missingKeyBehaviour;
    }

    public void setMissingKeyBehaviour(I18NService.MissingKeyBehaviour missingKeyBehaviour) {
        this.missingKeyBehaviour = missingKeyBehaviour;
    }
}

