/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.internal.UniqueAnnotations;
import com.google.inject.internal.util.$Lists;
import com.google.inject.internal.util.$Sets;
import com.google.inject.servlet.ServletDefinition;
import com.google.inject.servlet.ServletModule;
import com.google.inject.servlet.UriPatternType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServlet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ServletsModuleBuilder
extends AbstractModule {
    private final List<ServletDefinition> servletDefinitions = $Lists.newArrayList();
    private final List<ServletInstanceBindingEntry> servletInstanceEntries = $Lists.newArrayList();

    ServletsModuleBuilder() {
    }

    @Override
    protected void configure() {
        for (ServletInstanceBindingEntry entry : this.servletInstanceEntries) {
            this.bind(entry.key).toInstance(entry.servlet);
        }
        HashSet<String> servletUris = $Sets.newHashSet();
        for (ServletDefinition servletDefinition : this.servletDefinitions) {
            if (servletUris.contains(servletDefinition.getPattern())) {
                this.addError("More than one servlet was mapped to the same URI pattern: " + servletDefinition.getPattern(), new Object[0]);
                continue;
            }
            this.bind(Key.get(ServletDefinition.class, UniqueAnnotations.create())).toProvider(servletDefinition);
            servletUris.add(servletDefinition.getPattern());
        }
    }

    public ServletModule.ServletKeyBindingBuilder serve(List<String> urlPatterns) {
        return new ServletKeyBindingBuilderImpl(urlPatterns, UriPatternType.SERVLET);
    }

    public ServletModule.ServletKeyBindingBuilder serveRegex(List<String> regexes) {
        return new ServletKeyBindingBuilderImpl(regexes, UriPatternType.REGEX);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ServletKeyBindingBuilderImpl
    implements ServletModule.ServletKeyBindingBuilder {
        private final List<String> uriPatterns;
        private final UriPatternType uriPatternType;

        private ServletKeyBindingBuilderImpl(List<String> uriPatterns, UriPatternType uriPatternType) {
            this.uriPatterns = uriPatterns;
            this.uriPatternType = uriPatternType;
        }

        @Override
        public void with(Class<? extends HttpServlet> servletKey) {
            this.with(Key.get(servletKey));
        }

        @Override
        public void with(Key<? extends HttpServlet> servletKey) {
            this.with(servletKey, new HashMap<String, String>());
        }

        @Override
        public void with(HttpServlet servlet) {
            this.with(servlet, new HashMap<String, String>());
        }

        @Override
        public void with(Class<? extends HttpServlet> servletKey, Map<String, String> initParams) {
            this.with(Key.get(servletKey), initParams);
        }

        @Override
        public void with(Key<? extends HttpServlet> servletKey, Map<String, String> initParams) {
            this.with(servletKey, initParams, null);
        }

        private void with(Key<? extends HttpServlet> servletKey, Map<String, String> initParams, HttpServlet servletInstance) {
            for (String pattern : this.uriPatterns) {
                ServletsModuleBuilder.this.servletDefinitions.add(new ServletDefinition(pattern, servletKey, UriPatternType.get(this.uriPatternType, pattern), initParams, servletInstance));
            }
        }

        @Override
        public void with(HttpServlet servlet, Map<String, String> initParams) {
            Key<HttpServlet> servletKey = Key.get(HttpServlet.class, UniqueAnnotations.create());
            ServletsModuleBuilder.this.servletInstanceEntries.add(new ServletInstanceBindingEntry(servletKey, servlet));
            this.with(servletKey, initParams, servlet);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ServletInstanceBindingEntry {
        final Key<HttpServlet> key;
        final HttpServlet servlet;

        ServletInstanceBindingEntry(Key<HttpServlet> key, HttpServlet servlet) {
            this.key = key;
            this.servlet = servlet;
        }
    }
}

