/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.status;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.status.WarnStatus;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusUtil {
    public static boolean contextHasStatusListener(Context context) {
        StatusManager sm = context.getStatusManager();
        if (sm == null) {
            return false;
        }
        List<StatusListener> listeners = sm.getCopyOfStatusListenerList();
        return listeners != null && listeners.size() != 0;
    }

    public static List<Status> filterStatusListByTimeThreshold(List<Status> rawList, long threshold) {
        ArrayList<Status> filteredList = new ArrayList<Status>();
        for (Status s : rawList) {
            if (s.getDate() < threshold) continue;
            filteredList.add(s);
        }
        return filteredList;
    }

    public static void addStatus(Context context, Status status) {
        if (context == null) {
            return;
        }
        StatusManager sm = context.getStatusManager();
        if (sm != null) {
            sm.add(status);
        }
    }

    public static void addInfo(Context context, Object caller, String msg) {
        StatusUtil.addStatus(context, new InfoStatus(msg, caller));
    }

    public static void addWarn(Context context, Object caller, String msg) {
        StatusUtil.addStatus(context, new WarnStatus(msg, caller));
    }

    public static void addError(Context context, Object caller, String msg, Throwable t) {
        StatusUtil.addStatus(context, new ErrorStatus(msg, caller, t));
    }
}

