/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.util;

import com.ovea.tajin.framework.util.SystemPropertiesMode;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class PropertyPlaceholderResolver {
    public static final String DEFAULT_PLACEHOLDER_PREFIX = "${";
    public static final String DEFAULT_PLACEHOLDER_SUFFIX = "}";
    private final String placeholderPrefix = "${";
    private final String placeholderSuffix = "}";
    private boolean ignoreSystemEnvironment = false;
    private boolean ignoreUnresolvablePlaceholders = false;
    private SystemPropertiesMode systemPropertiesMode = SystemPropertiesMode.FALLBACK;

    public void setIgnoreSystemEnvironment(boolean ignoreSystemEnvironment) {
        this.ignoreSystemEnvironment = ignoreSystemEnvironment;
    }

    public void setIgnoreUnresolvablePlaceholders(boolean ignoreUnresolvablePlaceholders) {
        this.ignoreUnresolvablePlaceholders = ignoreUnresolvablePlaceholders;
    }

    public void setSystemPropertiesMode(SystemPropertiesMode systemPropertiesMode) {
        this.systemPropertiesMode = systemPropertiesMode;
    }

    public Properties resolveAll(Properties ... properties) {
        Properties p = new Properties();
        Properties all = new Properties();
        for (Properties props : properties) {
            all.putAll((Map<?, ?>)props);
        }
        for (String key : all.stringPropertyNames()) {
            String v = this.parseStringValue(all, all.getProperty(key), new HashSet<String>());
            String k = this.parseStringValue(all, key, new HashSet<String>());
            p.setProperty(k, v);
        }
        return p;
    }

    private String parseStringValue(Properties properties, String strVal, Set<String> visitedPlaceholders) {
        StringBuilder buf = new StringBuilder(strVal);
        int startIndex = strVal.indexOf(this.placeholderPrefix);
        while (startIndex != -1) {
            int endIndex = this.findPlaceholderEndIndex(buf, startIndex);
            if (endIndex != -1) {
                String placeholder = buf.substring(startIndex + this.placeholderPrefix.length(), endIndex);
                if (!visitedPlaceholders.add(placeholder)) {
                    throw new IllegalStateException("Circular placeholder reference '" + placeholder + "' in property definitions");
                }
                String propVal = this.resolvePlaceholder(properties, placeholder = this.parseStringValue(properties, placeholder, visitedPlaceholders), this.systemPropertiesMode);
                if (propVal != null) {
                    propVal = this.parseStringValue(properties, propVal, visitedPlaceholders);
                    buf.replace(startIndex, endIndex + this.placeholderSuffix.length(), propVal);
                    startIndex = buf.indexOf(this.placeholderPrefix, startIndex + propVal.length());
                } else if (this.ignoreUnresolvablePlaceholders) {
                    startIndex = buf.indexOf(this.placeholderPrefix, endIndex + this.placeholderSuffix.length());
                } else {
                    throw new IllegalStateException("Could not resolve placeholder '" + placeholder + "'");
                }
                visitedPlaceholders.remove(placeholder);
                continue;
            }
            startIndex = -1;
        }
        return buf.toString();
    }

    private int findPlaceholderEndIndex(CharSequence buf, int startIndex) {
        int index = startIndex + this.placeholderPrefix.length();
        int withinNestedPlaceholder = 0;
        while (index < buf.length()) {
            if (PropertyPlaceholderResolver.substringMatch(buf, index, this.placeholderSuffix)) {
                if (withinNestedPlaceholder > 0) {
                    --withinNestedPlaceholder;
                    index += this.placeholderSuffix.length();
                    continue;
                }
                return index;
            }
            if (PropertyPlaceholderResolver.substringMatch(buf, index, this.placeholderPrefix)) {
                ++withinNestedPlaceholder;
                index += this.placeholderPrefix.length();
                continue;
            }
            ++index;
        }
        return -1;
    }

    public String merge(String line, Properties properties) {
        return this.parseStringValue(properties, line, new HashSet<String>());
    }

    public String resolve(String placeholder, Properties properties) {
        return this.resolvePlaceholder(properties, placeholder, this.systemPropertiesMode);
    }

    private String resolvePlaceholder(Properties properties, String placeholder, SystemPropertiesMode mode) {
        String propVal = null;
        if (mode == SystemPropertiesMode.OVERRIDE) {
            propVal = this.resolveSystemProperty(placeholder);
        }
        if (propVal == null) {
            propVal = properties.getProperty(placeholder);
        }
        if (propVal == null && mode == SystemPropertiesMode.FALLBACK) {
            propVal = this.resolveSystemProperty(placeholder);
        }
        return propVal;
    }

    private String resolveSystemProperty(String key) {
        try {
            String value = System.getProperty(key);
            if (value == null && !this.ignoreSystemEnvironment) {
                value = System.getenv(key);
            }
            return value;
        }
        catch (RuntimeException ex) {
            return null;
        }
    }

    private static boolean substringMatch(CharSequence str, int index, CharSequence substring) {
        for (int j = 0; j < substring.length(); ++j) {
            int i = index + j;
            if (i < str.length() && str.charAt(i) == substring.charAt(j)) continue;
            return false;
        }
        return true;
    }
}

