/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.support.guice;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.ovea.tajin.framework.support.guice.DefaultLoader;
import com.ovea.tajin.framework.support.guice.Loader;
import com.ovea.tajin.framework.support.guice.ServiceClassLoader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.ArrayList;

public final class ServiceLoaderProvider<T>
implements Provider<T[]> {
    @Inject
    private Injector injector;
    private Key<? extends Loader> loaderKey;
    private final Class<T> type;

    private ServiceLoaderProvider(Class<T> type) {
        this.type = type;
    }

    public ServiceLoaderProvider<T> withLoader(Class<? extends Loader> loaderType) {
        return this.withLoader(Key.get(loaderType));
    }

    public ServiceLoaderProvider<T> withLoader(Class<? extends Loader> loaderType, Class<? extends Annotation> annot) {
        return this.withLoader(Key.get(loaderType, annot));
    }

    public ServiceLoaderProvider<T> withLoader(Class<? extends Loader> loaderType, Annotation annot) {
        return this.withLoader(Key.get(loaderType, annot));
    }

    public ServiceLoaderProvider<T> withLoader(Key<? extends Loader> key) {
        this.loaderKey = key;
        return this;
    }

    @Override
    public T[] get() {
        ArrayList<T> instances = new ArrayList<T>();
        ServiceClassLoader<T> loader = this.loaderKey == null ? ServiceClassLoader.load(this.type, new DefaultLoader()) : ServiceClassLoader.load(this.type, this.injector.getInstance(this.loaderKey));
        for (Class<T> clazz : loader) {
            if (!this.type.isAssignableFrom(clazz)) {
                throw new ClassCastException(clazz + " cannot be assigned to binded type " + this.type);
            }
            instances.add(this.injector.getInstance(clazz));
        }
        return instances.toArray((Object[])Array.newInstance(this.type, instances.size()));
    }

    public String toString() {
        return "ServiceLoaderProvider[" + this.type.getName() + "]";
    }

    public static <T> ServiceLoaderProvider<T> of(Class<T> type) {
        return new ServiceLoaderProvider<T>(type);
    }
}

